<x-admin-layout :title="__('Orders')" :subtitle="__('Manage and track plan purchases and subscriptions.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Order History') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('A complete record of all plan assignments and purchases.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print List') }}</button>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-4 sm:grid-cols-2">
                <div>
                    <input name="search" value="{{ request('search') }}" class="input-field" placeholder="{{ __('Search order # or user') }}">
                </div>
                <div>
                    <select name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="completed" @selected(request('status') === 'completed')>{{ __('Completed') }}</option>
                        <option value="pending" @selected(request('status') === 'pending')>{{ __('Pending') }}</option>
                        <option value="failed" @selected(request('status') === 'failed')>{{ __('Failed') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.orders.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Order Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Showing {{ $orders->count() }} of {{ $orders->total() }} entries.</p>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">{{ __('Order #') }}</th>
                            <th class="pb-3">{{ __('Plan / Description') }}</th>
                            <th class="pb-3">{{ __('User') }}</th>
                            <th class="pb-3">{{ __('Amount') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Date') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse($orders as $order)
                        <tr>
                            <td class="py-4">
                                <span class="font-bold text-ink">{{ $order->order_number }}</span>
                            </td>
                            <td class="py-4">
                                <p class="font-semibold text-ink">{{ $order->plan?->name ?? __('Free Plan') }}</p>
                                <p class="text-xs text-muted">{{ $order->payment_method ?: __('System') }}</p>
                            </td>
                            <td class="py-4 text-sm text-ink">{{ $order->user->name }}</td>
                            <td class="py-4 text-sm font-bold text-ink">
                                {{ $order->currency }} {{ number_format($order->amount, 2) }}
                            </td>
                            <td class="py-4">
                                @php
                                    $statusClasses = match($order->status) {
                                        'completed' => 'bg-emerald-500/10 text-emerald-500',
                                        'pending' => 'bg-amber-500/10 text-amber-500',
                                        'failed' => 'bg-rose-500/10 text-rose-500',
                                        default => 'bg-muted/10 text-muted'
                                    };
                                @endphp
                                <span class="inline-flex items-center rounded-full px-2.5 py-0.5 text-xs font-semibold {{ $statusClasses }} capitalize">
                                    {{ $order->status }}
                                </span>
                            </td>
                            <td class="py-4 text-sm text-muted">{{ $order->created_at->format('M d, Y') }}</td>
                            <td class="py-4 text-right">
                                <div class="inline-flex items-center gap-2">
                                    <a href="{{ route('admin.orders.show', $order) }}" target="_blank" class="btn-secondary flex items-center gap-2">
                                        <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                            <polyline points="14 2 14 8 20 8"></polyline>
                                            <path d="M16 13H8M16 17H8M10 9H8"></path>
                                        </svg>
                                        {{ __('Invoice') }}
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="py-12 text-center text-muted">
                                <div class="flex flex-col items-center">
                                    <svg viewBox="0 0 24 24" class="h-12 w-12 text-border/60 mb-3" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                        <line x1="8" y1="21" x2="16" y2="21"></line>
                                        <line x1="12" y1="17" x2="12" y2="21"></line>
                                    </svg>
                                    <p>{{ __('No orders found matching your criteria.') }}</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 border-t border-border/60 pt-6">
                {{ $orders->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
