<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-theme="light">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Invoice - {{ $order->order_number }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        body { font-family: 'Inter', system-ui, -apple-system, sans-serif; color: #1a1a1a; }

        @media print {
            .no-print { display: none !important; }
            html, body {
                background: #fff !important;
                margin: 0 !important;
                padding: 0 !important;
                overflow: visible !important;
                height: auto !important;
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
            body { display: block !important; }
            .invoice-scroll { overflow: visible !important; height: auto !important; padding: 0 !important; }
            .invoice-scroll > div { max-width: none !important; padding: 0 !important; }
            .invoice-page {
                box-shadow: none !important;
                border-radius: 0 !important;
                border: none !important;
            }
        }

        @page { margin: 18mm 20mm; size: A4; }
    </style>
</head>
<body class="bg-gray-100 h-screen overflow-hidden antialiased flex flex-col">

    @php
        $meta = $order->metadata ?? [];
        $originalPrice = (float) ($meta['original_price'] ?? $order->amount);
        $discountAmount = (float) ($meta['discount'] ?? 0);
        $couponCode = $meta['coupon_code'] ?? null;
        $baseCurrency = $meta['base_currency'] ?? $order->currency;
        $exchangeRate = $meta['exchange_rate'] ?? null;

        $currencyModel = \App\Models\Currency::where('code', $order->currency)->first();
        $sym = $currencyModel?->symbol ?: '$';

        $companyName = $siteSettings['company_name'] ?? ($siteSettings['site_name'] ?? config('app.name'));
        $companyAddr = $siteSettings['company_address'] ?? '';
        $companyEmail = $siteSettings['company_email'] ?? ($siteSettings['contact_email'] ?? '');
        $companyPhone = $siteSettings['company_phone'] ?? ($siteSettings['contact_phone'] ?? '');
        $hasLogo = !empty($siteSettings['site_logo']) && file_exists(storage_path('app/public/' . $siteSettings['site_logo']));

        $statusLabel = match($order->status) {
            'completed' => __('Paid'),
            'pending', 'pending_verification' => __('Unpaid'),
            'failed' => __('Failed'),
            'refunded' => __('Refunded'),
            'cancelled' => __('Cancelled'),
            default => ucfirst($order->status),
        };
        $statusColor = match($order->status) {
            'completed' => 'text-emerald-700 bg-emerald-50 border-emerald-200',
            'pending', 'pending_verification' => 'text-amber-700 bg-amber-50 border-amber-200',
            'failed' => 'text-red-700 bg-red-50 border-red-200',
            'refunded' => 'text-blue-700 bg-blue-50 border-blue-200',
            default => 'text-gray-700 bg-gray-50 border-gray-200',
        };
    @endphp

    {{-- Toolbar --}}
    <div class="no-print shrink-0 border-b border-gray-200 bg-white/80 backdrop-blur">
        <div class="mx-auto flex max-w-3xl items-center justify-between px-6 py-2.5">
            <button onclick="window.close()" class="inline-flex items-center gap-2 text-sm text-gray-500 transition hover:text-gray-900">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="19" y1="12" x2="5" y2="12"/><polyline points="12 19 5 12 12 5"/></svg>
                {{ __('Back') }}
            </button>
            <div class="flex items-center gap-2">
                @if(auth()->user()?->hasRole(['Super Admin', 'Admin']))
                <div x-data="{ open: false }" class="relative">
                    <button @click="open = !open" class="inline-flex items-center gap-1.5 rounded-lg border border-gray-200 px-3 py-1.5 text-xs font-medium text-gray-600 transition hover:bg-gray-50">
                        <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="1"/><circle cx="12" cy="5" r="1"/><circle cx="12" cy="19" r="1"/></svg>
                        {{ __('Update Status') }}
                    </button>
                    <div x-show="open" @click.outside="open = false" x-transition x-cloak class="absolute right-0 top-full mt-1.5 w-72 rounded-xl border border-gray-200 bg-white p-4 shadow-lg z-20">
                        @if(session('success'))
                            <p class="mb-3 rounded-lg bg-emerald-50 px-3 py-2 text-xs font-medium text-emerald-700">{{ session('success') }}</p>
                        @endif
                        <form action="{{ route('admin.orders.update-status', $order) }}" method="POST" class="space-y-2.5">
                            @csrf
                            @method('PATCH')
                            <div>
                                <label class="block text-xs font-medium text-gray-500 mb-1">{{ __('Status') }}</label>
                                <select name="status" class="w-full rounded-lg border border-gray-200 bg-white px-3 py-1.5 text-sm focus:border-gray-400 focus:outline-none">
                                    @foreach(['pending', 'pending_verification', 'completed', 'failed', 'refunded', 'cancelled'] as $s)
                                        <option value="{{ $s }}" @selected($order->status === $s)>{{ ucfirst(str_replace('_', ' ', $s)) }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-500 mb-1">{{ __('Note') }}</label>
                                <input type="text" name="note" class="w-full rounded-lg border border-gray-200 bg-white px-3 py-1.5 text-sm placeholder:text-gray-400 focus:border-gray-400 focus:outline-none" placeholder="{{ __('Optional...') }}" maxlength="500" />
                            </div>
                            <button type="submit" class="w-full rounded-lg bg-gray-900 px-3 py-1.5 text-xs font-medium text-white transition hover:bg-gray-800">{{ __('Update') }}</button>
                        </form>
                    </div>
                </div>
                @endif
                <button onclick="window.print()" class="inline-flex items-center gap-1.5 rounded-lg bg-gray-900 px-4 py-1.5 text-xs font-medium text-white transition hover:bg-gray-800">
                    <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="6 9 6 2 18 2 18 9"/><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"/><rect x="6" y="14" width="12" height="8"/></svg>
                    {{ __('Print') }}
                </button>
            </div>
        </div>
    </div>

    {{-- Scrollable invoice area --}}
    <div class="invoice-scroll flex-1 overflow-y-auto">
        <div class="mx-auto max-w-3xl px-6 py-6">
            <div class="invoice-page rounded-lg border border-gray-200 bg-white shadow-sm" style="padding: 36px 44px;">

                {{-- HEADER --}}
                <div class="flex items-start justify-between">
                    <div>
                        @if($hasLogo)
                            <img src="{{ asset('storage/' . $siteSettings['site_logo']) }}" alt="{{ $companyName }}" class="h-9 w-auto max-w-48 object-contain">
                        @else
                            <p class="text-lg font-bold text-gray-900 tracking-tight">{{ $companyName }}</p>
                        @endif
                        @if($companyAddr)
                            <p class="mt-1.5 text-xs text-gray-500 leading-relaxed max-w-52">{{ $companyAddr }}</p>
                        @endif
                        @if($companyEmail)
                            <p class="text-xs text-gray-500 mt-0.5">{{ $companyEmail }}</p>
                        @endif
                        @if($companyPhone)
                            <p class="text-xs text-gray-500">{{ $companyPhone }}</p>
                        @endif
                    </div>
                    <div class="text-right">
                        <p class="text-2xl font-bold text-gray-900 tracking-tight">{{ __('Invoice') }}</p>
                        <p class="mt-0.5 text-sm text-gray-500 font-mono">#{{ $order->order_number }}</p>
                        <div class="mt-2">
                            <span class="inline-block rounded-md border px-2.5 py-0.5 text-xs font-semibold {{ $statusColor }}">{{ $statusLabel }}</span>
                        </div>
                    </div>
                </div>

                {{-- META --}}
                <div class="mt-7 grid grid-cols-3 gap-5 text-sm">
                    <div>
                        <p class="text-[11px] font-medium text-gray-400 uppercase tracking-wider">{{ __('Bill To') }}</p>
                        <p class="mt-1 font-semibold text-gray-900">{{ $order->user->name }}</p>
                        <p class="text-gray-500 text-sm">{{ $order->user->email }}</p>
                    </div>
                    <div>
                        <p class="text-[11px] font-medium text-gray-400 uppercase tracking-wider">{{ __('Issue Date') }}</p>
                        <p class="mt-1 font-semibold text-gray-900">{{ $order->created_at->format('M d, Y') }}</p>
                    </div>
                    <div>
                        <p class="text-[11px] font-medium text-gray-400 uppercase tracking-wider">{{ __('Payment Method') }}</p>
                        <p class="mt-1 font-semibold text-gray-900">{{ $order->payment_method ?: __('Online Payment') }}</p>
                        @if($order->gateway_transaction_id)
                            <p class="text-[11px] text-gray-400 font-mono truncate" title="{{ $order->gateway_transaction_id }}">{{ $order->gateway_transaction_id }}</p>
                        @endif
                    </div>
                </div>

                {{-- LINE ITEMS --}}
                <div class="mt-7">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b-2 border-gray-900">
                                <th class="pb-2 text-left text-[11px] font-semibold text-gray-900 uppercase tracking-wider">{{ __('Description') }}</th>
                                <th class="pb-2 text-center text-[11px] font-semibold text-gray-900 uppercase tracking-wider w-16">{{ __('Qty') }}</th>
                                <th class="pb-2 text-right text-[11px] font-semibold text-gray-900 uppercase tracking-wider">{{ __('Unit Price') }}</th>
                                <th class="pb-2 text-right text-[11px] font-semibold text-gray-900 uppercase tracking-wider">{{ __('Amount') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="border-b border-gray-100">
                                <td class="py-3 pr-4">
                                    <p class="text-sm font-medium text-gray-900">{{ $order->plan?->name ?? __('Plan') }} {{ __('Subscription') }}</p>
                                    @if($order->plan?->billing_cycle)
                                        <p class="text-xs text-gray-400 mt-0.5">{{ ucfirst($order->plan->billing_cycle) }} billing</p>
                                    @endif
                                </td>
                                <td class="py-3 text-center text-sm text-gray-600">1</td>
                                <td class="py-3 text-right text-sm text-gray-600 font-mono">{{ $sym }}{{ number_format($originalPrice, 2) }}</td>
                                <td class="py-3 text-right text-sm font-semibold text-gray-900 font-mono">{{ $sym }}{{ number_format($originalPrice, 2) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                {{-- TOTALS --}}
                <div class="mt-4 flex justify-end">
                    <div class="w-60 space-y-1.5 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-500">{{ __('Subtotal') }}</span>
                            <span class="font-mono text-gray-900">{{ $sym }}{{ number_format($originalPrice, 2) }}</span>
                        </div>

                        @if($discountAmount > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-500">{{ __('Discount') }} @if($couponCode)<span class="text-xs text-gray-400">({{ $couponCode }})</span>@endif</span>
                            <span class="font-mono text-emerald-600">-{{ $sym }}{{ number_format($discountAmount, 2) }}</span>
                        </div>
                        @endif

                        @if($exchangeRate && $baseCurrency !== $order->currency)
                        <div class="flex justify-between text-xs">
                            <span class="text-gray-400">{{ __('Currency conversion') }}</span>
                            <span class="font-mono text-gray-400">{{ $baseCurrency }} &rarr; {{ $order->currency }}</span>
                        </div>
                        @endif

                        <div class="flex justify-between border-t-2 border-gray-900 pt-2.5">
                            <span class="text-base font-bold text-gray-900">{{ __('Total Due') }}</span>
                            <span class="text-base font-bold text-gray-900 font-mono">{{ $sym }}{{ number_format($order->amount, 2) }}</span>
                        </div>

                        @if($order->currency)
                        <div class="text-right">
                            <span class="text-xs text-gray-400">{{ $order->currency }}</span>
                        </div>
                        @endif
                    </div>
                </div>

                {{-- FOOTER --}}
                <div class="mt-10 border-t border-gray-100 pt-4">
                    <div class="flex items-end justify-between">
                        <div>
                            <p class="text-xs text-gray-400">{{ __('Thank you for your business.') }}</p>
                            @if($companyEmail)
                                <p class="text-xs text-gray-400 mt-0.5">{{ __('Questions? Contact') }} {{ $companyEmail }}</p>
                            @endif
                        </div>
                        <div class="text-right">
                            @if($hasLogo)
                                <img src="{{ asset('storage/' . $siteSettings['site_logo']) }}" alt="" class="h-5 w-auto opacity-25 ml-auto object-contain">
                            @else
                                <p class="text-xs text-gray-300 font-semibold">{{ $companyName }}</p>
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

</body>
</html>
