<x-admin-layout :title="__('Pages')" :subtitle="__('Manage custom pages created by administrators.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Custom Pages') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Create and manage additional pages for your website.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-pages')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/pages.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.pages.create') }}" class="btn-primary">{{ __('Add Page') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.6fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search title, slug, or description') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="title_asc" @selected($sort === 'title_asc')>{{ __('Title (A-Z)') }}</option>
                        <option value="title_desc" @selected($sort === 'title_desc')>{{ __('Title (Z-A)') }}</option>
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.pages.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="pages-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Page Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Showing {{ $pages->count() }} of {{ $pages->total() }} pages.</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.pages.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-page-bulk-delete">
                        {{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Page') }}</th>
                            <th class="pb-3">{{ __('Type') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Updated') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($pages as $page)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $page->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $page->title }}</p>
                                    <p class="text-xs text-muted">{{ $page->slug }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $types[$page->type] ?? ucfirst(str_replace('_', ' ', $page->type)) }}</td>
                                <td class="py-4 text-sm text-ink">{{ $page->is_active ? __('Active') : __('Inactive') }}</td>
                                <td class="py-4 text-sm text-ink">{{ \App\Support\FormatSettings::date($page->updated_at) }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.pages.show', $page) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.pages.edit', $page) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-page-delete-{{ $page->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-page-delete-{{ $page->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.pages.destroy', $page) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">Delete {{ $page->title }}?</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-6 text-center text-sm text-muted">{{ __('No pages found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($pages as $page)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $page->title }}</p>
                                <p class="text-xs text-muted">{{ $page->slug }}</p>
                            </div>
                            <span class="badge">{{ $page->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-3 text-sm text-ink">{{ $types[$page->type] ?? ucfirst(str_replace('_', ' ', $page->type)) }}</div>
                        <div class="mt-2 text-xs text-muted">{{ \Illuminate\Support\Str::limit($page->description, 120) }}</div>
                        <div class="mt-2 text-xs text-muted">{{ __('Updated') }} {{ \App\Support\FormatSettings::date($page->updated_at) }}</div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.pages.show', $page) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.pages.edit', $page) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                        {{ __('No pages found.') }}
                    </div>
                @endforelse
            </div>

            <x-modal name="confirm-page-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.pages.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected pages?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            {{ __('You are about to remove') }} <span class="font-semibold text-ink" data-bulk-selected>0</span> {{ __('page(s).') }}
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-pages" :show="false" focusable>
                <form method="POST" action="{{ route('admin.pages.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Pages') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="pages_file" :value="__('CSV File')" />
                        <input id="pages_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $pages->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
