﻿@php
    $isEdit = isset($page) && $page;
@endphp

<div class="grid gap-6 lg:grid-cols-3">
    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Page Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="title" :value="__('Title')" />
                <x-text-input id="title" name="title" type="text" class="mt-1" :value="old('title', $isEdit ? $page->title : '')" required />
                <x-input-error :messages="$errors->get('title')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="type" :value="__('Page Type')" />
                <select id="type" name="type" class="input-field mt-1" required>
                    @foreach ($types as $value => $label)
                        <option value="{{ $value }}" @selected(old('type', $isEdit ? $page->type : '') === $value)>{{ $label }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('type')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="description" :value="__('Description')" />
                <textarea id="description" name="description" rows="6" class="input-field mt-1">{{ old('description', $isEdit ? $page->description : '') }}</textarea>
                <x-input-error :messages="$errors->get('description')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label :value="__('Active')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $page->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $page->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Slug')" />
                    <p class="mt-2 text-sm text-muted">{{ $page->slug }}</p>
                </div>
            @endif
        </div>
    </div>
</div>

