<x-admin-layout :title="__('Page Details')" :subtitle="__('Review page content and metadata.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Page') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $page->title }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $page->slug }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.pages.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.pages.edit', $page) }}" class="btn-primary">{{ __('Edit Page') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Type') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $types[$page->type] ?? ucfirst(str_replace('_', ' ', $page->type)) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $page->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::date($page->created_at) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Updated') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::date($page->updated_at) }}</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <p class="panel-heading">{{ __('Description') }}</p>
            <p class="mt-3 text-sm text-muted">{{ $page->description ?: __('No description provided.') }}</p>
        </div>
    </div>
</x-admin-layout>
