<x-admin-layout :title="__('Payment Gateways')" :subtitle="__('Configure payment providers, credentials, and modes.')">
    <div class="space-y-6" x-data="paymentGateways()">
        {{-- Header Panel --}}
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Gateway Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ $gateways->count() }} {{ __('payment gateways available. Enable and configure the ones you need.') }}</p>
                </div>
            </div>

            <div class="mt-5">
                <label class="sr-only" for="gateway-search">{{ __('Search gateways') }}</label>
                <div class="relative">
                    <svg viewBox="0 0 24 24" class="absolute left-3 top-1/2 h-4 w-4 -translate-y-1/2 text-muted" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="11" cy="11" r="7"></circle>
                        <path d="M20 20l-3.5-3.5"></path>
                    </svg>
                    <input
                        id="gateway-search"
                        type="search"
                        class="input-field pl-10"
                        placeholder="{{ __('Search by gateway name...') }}"
                        x-model="search"
                    >
                </div>
            </div>
        </div>

        {{-- Gateway List --}}
        <div class="space-y-3">
            @forelse ($gateways as $gateway)
                <div
                    class="panel overflow-hidden"
                    x-data="{ expanded: false }"
                    x-show="! search || {{ Js::from(strtolower($gateway->name)) }}.includes(search.toLowerCase()) || {{ Js::from(strtolower($gateway->slug)) }}.includes(search.toLowerCase())"
                    x-transition
                >
                    {{-- Collapsed Header --}}
                    <div class="flex items-center justify-between gap-4 px-6 py-4">
                        <button
                            type="button"
                            class="flex min-w-0 flex-1 items-center gap-4 text-left"
                            @click="expanded = !expanded"
                        >
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-surface-2/70 text-muted">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><rect width="20" height="14" x="2" y="5" rx="2"/><line x1="2" x2="22" y1="10" y2="10"/></svg>
                            </div>
                            <div class="min-w-0 flex-1">
                                <div class="flex items-center gap-2">
                                    <p class="truncate font-semibold text-ink">{{ $gateway->name }}</p>
                                    @if ($gateway->is_active)
                                        <span class="inline-flex items-center rounded-md bg-emerald-500/10 px-2 py-0.5 text-[11px] font-medium text-emerald-600 ring-1 ring-inset ring-emerald-500/20">{{ __('Active') }}</span>
                                    @else
                                        <span class="inline-flex items-center rounded-md bg-slate-500/10 px-2 py-0.5 text-[11px] font-medium text-slate-500 ring-1 ring-inset ring-slate-500/20">{{ __('Inactive') }}</span>
                                    @endif
                                    @if ($gateway->mode === 'sandbox')
                                        <span class="inline-flex items-center rounded-md bg-amber-500/10 px-2 py-0.5 text-[11px] font-medium text-amber-600 ring-1 ring-inset ring-amber-500/20">{{ __('Sandbox') }}</span>
                                    @else
                                        <span class="inline-flex items-center rounded-md bg-blue-500/10 px-2 py-0.5 text-[11px] font-medium text-blue-600 ring-1 ring-inset ring-blue-500/20">{{ __('Live') }}</span>
                                    @endif
                                </div>
                                @if ($gateway->description)
                                    <p class="mt-0.5 truncate text-xs text-muted">{{ $gateway->description }}</p>
                                @endif
                                @if (! empty($gateway->supported_currencies))
                                    <div class="mt-1 flex flex-wrap gap-1">
                                        @foreach (array_slice($gateway->supported_currencies, 0, 6) as $cur)
                                            <span class="inline-flex items-center rounded bg-surface-2/70 px-1.5 py-0.5 text-[10px] font-medium text-muted">{{ $cur }}</span>
                                        @endforeach
                                        @if (count($gateway->supported_currencies) > 6)
                                            <span class="inline-flex items-center rounded bg-surface-2/70 px-1.5 py-0.5 text-[10px] font-medium text-muted">+{{ count($gateway->supported_currencies) - 6 }} {{ __('more') }}</span>
                                        @endif
                                    </div>
                                @elseif (in_array($gateway->slug, ['bank_transfer', 'offline']))
                                    <div class="mt-1">
                                        <span class="inline-flex items-center rounded bg-surface-2/70 px-1.5 py-0.5 text-[10px] font-medium text-muted">{{ __('All currencies') }}</span>
                                    </div>
                                @endif
                            </div>
                            <svg
                                viewBox="0 0 24 24"
                                class="h-5 w-5 shrink-0 text-muted transition-transform duration-200"
                                :class="expanded && 'rotate-180'"
                                fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"
                            >
                                <path d="M6 9l6 6 6-6"></path>
                            </svg>
                        </button>

                        {{-- Toggle Switch --}}
                        <form method="POST" action="{{ route('admin.payment-gateways.toggle', $gateway) }}" class="shrink-0">
                            @csrf
                            <label class="inline-flex cursor-pointer items-center gap-2 text-sm text-muted">
                                <button type="submit" class="relative inline-flex h-6 w-11 items-center rounded-full transition {{ $gateway->is_active ? 'bg-brand' : 'bg-border' }}" title="{{ $gateway->is_active ? __('Click to disable') : __('Click to enable') }}">
                                    <span class="inline-block h-5 w-5 rounded-full bg-white shadow transition" style="transform: translateX({{ $gateway->is_active ? '1.25rem' : '0.125rem' }})"></span>
                                </button>
                            </label>
                        </form>
                    </div>

                    {{-- Expanded Form --}}
                    <div x-show="expanded" x-collapse>
                        <div class="border-t border-border/60 px-6 py-6">
                            <form method="POST" action="{{ route('admin.payment-gateways.update', $gateway) }}" class="space-y-6">
                                @csrf
                                @method('PUT')

                                {{-- Mode Selector --}}
                                <div class="panel p-5">
                                    <p class="panel-heading">{{ __('Environment') }}</p>
                                    <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                        <div>
                                            <x-input-label for="mode_{{ $gateway->id }}" :value="__('Mode')" />
                                            <select id="mode_{{ $gateway->id }}" name="mode" class="input-field mt-1">
                                                <option value="sandbox" @selected($gateway->mode === 'sandbox')>{{ __('Sandbox / Test') }}</option>
                                                <option value="live" @selected($gateway->mode === 'live')>{{ __('Live / Production') }}</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                {{-- Supported Currencies --}}
                                @if (! empty($gateway->supported_currencies))
                                    <div class="panel p-5">
                                        <p class="panel-heading">{{ __('Supported Currencies') }}</p>
                                        <div class="mt-3 flex flex-wrap gap-1.5">
                                            @foreach ($gateway->supported_currencies as $cur)
                                                <span class="inline-flex items-center rounded-lg bg-surface-2/70 px-2.5 py-1 text-xs font-medium text-ink ring-1 ring-inset ring-border/40">{{ $cur }}</span>
                                            @endforeach
                                        </div>
                                    </div>
                                @elseif (in_array($gateway->slug, ['bank_transfer', 'offline']))
                                    <div class="panel p-5">
                                        <p class="panel-heading">{{ __('Supported Currencies') }}</p>
                                        <p class="mt-2 text-sm text-muted">{{ __('Accepts all currencies (manual verification by admin).') }}</p>
                                    </div>
                                @endif

                                {{-- Credential Fields --}}
                                @if (count($gateway->credentialFields) > 0)
                                    <div class="panel p-5">
                                        <p class="panel-heading">{{ __('Credentials') }}</p>
                                        <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                            @foreach ($gateway->credentialFields as $field)
                                                <div>
                                                    <x-input-label
                                                        for="cred_{{ $gateway->id }}_{{ $field['key'] }}"
                                                        :value="__($field['label'])"
                                                    />
                                                    @if (($field['type'] ?? 'text') === 'password')
                                                        <div class="relative mt-1">
                                                            <input
                                                                id="cred_{{ $gateway->id }}_{{ $field['key'] }}"
                                                                name="credentials[{{ $field['key'] }}]"
                                                                type="password"
                                                                class="input-field pr-12"
                                                                autocomplete="new-password"
                                                                placeholder="{{ ! empty($gateway->decryptedCredentials[$field['key']]) ? str_repeat("\u{2022}", 8) : '' }}"
                                                            />
                                                            <button
                                                                type="button"
                                                                class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink"
                                                                onclick="
                                                                    const inp = document.getElementById('cred_{{ $gateway->id }}_{{ $field['key'] }}');
                                                                    inp.type = inp.type === 'password' ? 'text' : 'password';
                                                                "
                                                                aria-label="Toggle visibility"
                                                            >
                                                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                                                    <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                                                                    <circle cx="12" cy="12" r="3"></circle>
                                                                </svg>
                                                            </button>
                                                        </div>
                                                        @if (! empty($gateway->decryptedCredentials[$field['key']]))
                                                            <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden). Leave blank to keep current value.') }}</p>
                                                        @endif
                                                    @elseif (($field['type'] ?? 'text') === 'textarea')
                                                        <textarea
                                                            id="cred_{{ $gateway->id }}_{{ $field['key'] }}"
                                                            name="credentials[{{ $field['key'] }}]"
                                                            rows="4"
                                                            class="input-field mt-1"
                                                            data-no-wysiwyg
                                                        >{{ old('credentials.' . $field['key'], $gateway->decryptedCredentials[$field['key']] ?? '') }}</textarea>
                                                    @elseif (($field['type'] ?? 'text') === 'select')
                                                        <select
                                                            id="cred_{{ $gateway->id }}_{{ $field['key'] }}"
                                                            name="credentials[{{ $field['key'] }}]"
                                                            class="input-field mt-1"
                                                        >
                                                            @foreach (($field['options'] ?? []) as $optVal => $optLabel)
                                                                <option value="{{ $optVal }}" @selected(old('credentials.' . $field['key'], $gateway->decryptedCredentials[$field['key']] ?? '') === (string) $optVal)>{{ $optLabel }}</option>
                                                            @endforeach
                                                        </select>
                                                    @else
                                                        <input
                                                            id="cred_{{ $gateway->id }}_{{ $field['key'] }}"
                                                            name="credentials[{{ $field['key'] }}]"
                                                            type="text"
                                                            class="input-field mt-1"
                                                            value="{{ old('credentials.' . $field['key'], $gateway->decryptedCredentials[$field['key']] ?? '') }}"
                                                            @if (! empty($field['placeholder'])) placeholder="{{ $field['placeholder'] }}" @endif
                                                        />
                                                    @endif
                                                    @if (! empty($field['hint']))
                                                        <p class="mt-1 text-xs text-muted">{{ $field['hint'] }}</p>
                                                    @endif
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @else
                                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                                        {{ __('No driver class found for') }} <span class="font-semibold text-ink">{{ $gateway->slug }}</span>. {{ __('Create') }} <code class="rounded bg-surface-2 px-1.5 py-0.5 text-xs font-mono">App\Services\Payment\Drivers\{{ \Illuminate\Support\Str::studly($gateway->slug) }}Driver</code> {{ __('with a static') }} <code class="rounded bg-surface-2 px-1.5 py-0.5 text-xs font-mono">credentialFields()</code> {{ __('method to configure credentials here.') }}
                                    </div>
                                @endif

                                {{-- Save Button --}}
                                <div class="flex justify-end">
                                    <button type="submit" class="btn-primary">{{ __('Save') }} {{ $gateway->name }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            @empty
                <div class="panel p-6 text-center">
                    <p class="text-sm text-muted">{{ __('No payment gateways found. Run the database seeder to populate gateways.') }}</p>
                </div>
            @endforelse
        </div>
    </div>

    @push('scripts')
    <script>
        function paymentGateways() {
            return {
                search: '',
            };
        }
    </script>
    @endpush
</x-admin-layout>
