@php
    $isEdit = isset($permission) && $permission;
    $selectedGuard = old('guard_name', $isEdit ? $permission->guard_name : 'web');
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Permission Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Permission Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $permission->name : '')" required />
                <p class="mt-2 text-xs text-muted">{{ __('Use dot notation (example: users.create).') }}</p>
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="guard_name" :value="__('Guard Name')" />
                <select id="guard_name" name="guard_name" class="input-field mt-1">
                    @foreach ($guards as $guard)
                        <option value="{{ $guard }}" @selected((string) $selectedGuard === (string) $guard)>{{ $guard }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('guard_name')" class="mt-2" />
            </div>
        </div>
    </div>
</div>
