<x-admin-layout :title="__('Permission Details')" :subtitle="__('Review permission usage and guard.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Permission') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $permission->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Guard') }}: {{ $permission->guard_name }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.permissions.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.permissions.edit', $permission) }}" class="btn-primary">{{ __('Edit Permission') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Roles') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $permission->roles_count }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Last Updated') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::date($permission->updated_at) }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
