﻿@php
    $isEdit = isset($plan) && $plan;
    $features = old('features', $isEdit ? ($plan->features ?? []) : []);
    if (! is_array($features)) {
        $features = [];
    }
    if (count($features) === 0) {
        $features = [''];
    }
    $selectedDuration = old('duration_type', $isEdit ? $plan->duration_type : 'months');
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Plan Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Plan Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $plan->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-input-label for="price" :value="__('Price')" />
                    <x-text-input id="price" name="price" type="number" step="0.01" min="0" class="mt-1" :value="old('price', $isEdit ? $plan->price : '')" required />
                    <x-input-error :messages="$errors->get('price')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="offer_price" :value="__('Offer Price')" />
                    <x-text-input id="offer_price" name="offer_price" type="number" step="0.01" min="0" class="mt-1" :value="old('offer_price', $isEdit ? $plan->offer_price : '')" />
                    <x-input-error :messages="$errors->get('offer_price')" class="mt-2" />
                </div>
            </div>
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-input-label for="images_limit" :value="__('Images Upload Limit')" />
                    <x-text-input id="images_limit" name="images_limit" type="number" min="0" class="mt-1" :value="old('images_limit', $isEdit ? $plan->images_limit : '')" placeholder="{{ __('Leave blank for unlimited') }}" />
                    <x-input-error :messages="$errors->get('images_limit')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="events_limit" :value="__('Events Create Limit')" />
                    <x-text-input id="events_limit" name="events_limit" type="number" min="0" class="mt-1" :value="old('events_limit', $isEdit ? $plan->events_limit : '')" placeholder="{{ __('Leave blank for unlimited') }}" />
                    <x-input-error :messages="$errors->get('events_limit')" class="mt-2" />
                </div>
            </div>
            <div>
                <x-input-label for="storage_limit_gb" :value="__('Storage Limit (GB)')" />
                <x-text-input id="storage_limit_gb" name="storage_limit_gb" type="number" step="0.01" min="0" class="mt-1" :value="old('storage_limit_gb', $isEdit ? $plan->storage_limit_gb : '')" placeholder="{{ __('Leave blank for unlimited') }}" />
                <x-input-error :messages="$errors->get('storage_limit_gb')" class="mt-2" />
            </div>
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-input-label for="videos_limit" :value="__('Videos Upload Limit')" />
                    <x-text-input id="videos_limit" name="videos_limit" type="number" min="0" class="mt-1" :value="old('videos_limit', $isEdit ? $plan->videos_limit : '')" placeholder="{{ __('Leave blank for unlimited') }}" />
                    <x-input-error :messages="$errors->get('videos_limit')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="max_file_size_mb" :value="__('Max File Size (MB)')" />
                    <x-text-input id="max_file_size_mb" name="max_file_size_mb" type="number" min="1" class="mt-1" :value="old('max_file_size_mb', $isEdit ? $plan->max_file_size_mb : '')" placeholder="{{ __('Leave blank for system default') }}" />
                    <x-input-error :messages="$errors->get('max_file_size_mb')" class="mt-2" />
                </div>
            </div>
            <div class="grid gap-4 sm:grid-cols-2">
                <div>
                    <x-input-label for="duration_type" :value="__('Duration Type')" />
                    <select id="duration_type" name="duration_type" class="input-field mt-1" required>
                        <option value="months" @selected($selectedDuration === 'months')>{{ __('Monthly') }}</option>
                        <option value="lifetime" @selected($selectedDuration === 'lifetime')>{{ __('Lifetime') }}</option>
                    </select>
                    <x-input-error :messages="$errors->get('duration_type')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="duration_months" :value="__('Duration (Months)')" />
                    <x-text-input id="duration_months" name="duration_months" type="number" min="1" class="mt-1" :value="old('duration_months', $isEdit ? $plan->duration_months : '')" placeholder="{{ __('Required for monthly plans') }}" />
                    <x-input-error :messages="$errors->get('duration_months')" class="mt-2" />
                </div>
            </div>
        </div>
    </div>

    <div class="panel p-6" data-feature-list>
        <p class="panel-heading">{{ __('Plan Features') }}</p>
        <div class="mt-4 space-y-3" data-feature-items>
            @foreach ($features as $feature)
                <div class="flex flex-wrap items-center gap-3" data-feature-item>
                    <input name="features[]" type="text" class="input-field flex-1" value="{{ $feature }}" placeholder="{{ __('Feature detail') }}">
                    <button type="button" class="btn-secondary" data-feature-remove>{{ __('Remove') }}</button>
                </div>
            @endforeach
        </div>
        <div class="mt-4">
            <button type="button" class="btn-secondary" data-feature-add>{{ __('Add Feature') }}</button>
        </div>
        <template data-feature-template>
            <div class="flex flex-wrap items-center gap-3" data-feature-item>
                <input name="features[]" type="text" class="input-field flex-1" placeholder="{{ __('Feature detail') }}">
                <button type="button" class="btn-secondary" data-feature-remove>{{ __('Remove') }}</button>
            </div>
        </template>
        @php
            $featureErrors = array_merge($errors->get('features'), $errors->get('features.*'));
        @endphp
        <x-input-error :messages="$featureErrors" class="mt-2" />
    </div>

    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Plan Capabilities & Status') }}</p>
        <div class="mt-4 grid gap-6 sm:grid-cols-2 lg:grid-cols-4">
            <div>
                <x-input-label :value="__('Watermark')" />
                <input type="hidden" name="has_watermark" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="has_watermark" value="1" class="peer sr-only" @checked((bool) old('has_watermark', $isEdit ? $plan->has_watermark : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('Apply Watermark') }}</span>
                </label>
                <p class="mt-1 text-xs text-muted">{{ __('Any image upload by non-admin users will get a watermark.') }}</p>
            </div>
            <div>
                <x-input-label :value="__('Design Editor')" />
                <input type="hidden" name="has_design_editor" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="has_design_editor" value="1" class="peer sr-only" @checked((bool) old('has_design_editor', $isEdit ? $plan->has_design_editor : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('Enable Design Editor') }}</span>
                </label>
                <p class="mt-1 text-xs text-muted">{{ __('Users can access the advanced design editor for events.') }}</p>
            </div>
            <div>
                <x-input-label :value="__('Guest Upload')" />
                <input type="hidden" name="has_guest_upload" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="has_guest_upload" value="1" class="peer sr-only" @checked((bool) old('has_guest_upload', $isEdit ? $plan->has_guest_upload : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('Allow Guest Upload') }}</span>
                </label>
                <p class="mt-1 text-xs text-muted">{{ __('Allow event visitors to upload photos/videos.') }}</p>
            </div>
            <div>
                <x-input-label :value="__('Google Drive Import')" />
                <input type="hidden" name="has_google_drive_import" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="has_google_drive_import" value="1" class="peer sr-only" @checked((bool) old('has_google_drive_import', $isEdit ? $plan->has_google_drive_import : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('Google Drive Import') }}</span>
                </label>
                <p class="mt-1 text-xs text-muted">{{ __('Import media from Google Drive folders.') }}</p>
            </div>
            <div>
                <x-input-label :value="__('FTP Tethering')" />
                <input type="hidden" name="has_ftp_import" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="has_ftp_import" value="1" class="peer sr-only" @checked((bool) old('has_ftp_import', $isEdit ? $plan->has_ftp_import : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('FTP Camera Tethering') }}</span>
                </label>
                <p class="mt-1 text-xs text-muted">{{ __('Live import via camera FTP connection.') }}</p>
            </div>
            <div>
                <x-input-label :value="__('Custom Branding')" />
                <input type="hidden" name="has_custom_branding" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="has_custom_branding" value="1" class="peer sr-only" @checked((bool) old('has_custom_branding', $isEdit ? $plan->has_custom_branding : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('Custom Branding') }}</span>
                </label>
                <p class="mt-1 text-xs text-muted">{{ __('Remove "Powered by" branding from share pages.') }}</p>
            </div>
            <div>
                <x-input-label :value="__('Cloud Storage')" />
                <input type="hidden" name="has_cloud_storage" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="has_cloud_storage" value="1" class="peer sr-only" @checked((bool) old('has_cloud_storage', $isEdit ? $plan->has_cloud_storage : false))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ __('Cloud Storage') }}</span>
                </label>
                <p class="mt-1 text-xs text-muted">{{ __('Use external cloud storage (S3, GCS, etc).') }}</p>
            </div>
            <div>
                <x-input-label :value="__('Plan Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $plan->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $plan->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
        </div>
    </div>
</div>

