﻿<x-admin-layout :title="__('Plan Details')" :subtitle="__('Review plan pricing, limits, and coupons.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Plan') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $plan->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Slug:') }} {{ $plan->slug }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.plans.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.plans.edit', $plan) }}" class="btn-primary">{{ __('Edit Plan') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Price') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $plan->price == 0 ? __('Free') : \App\Support\FormatSettings::currency($plan->price) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Offer Price') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $plan->offer_price !== null ? \App\Support\FormatSettings::currency($plan->offer_price) : __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Duration') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">
                        {{ $plan->duration_type === 'lifetime' ? __('Lifetime') : ($plan->duration_months ? $plan->duration_months . ' ' . __('months') : __('Monthly')) }}
                    </p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $plan->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Images Limit') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $plan->images_limit !== null ? $plan->images_limit : __('Unlimited') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Events Limit') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $plan->events_limit !== null ? $plan->events_limit : __('Unlimited') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Storage Limit') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $plan->storage_limit_gb !== null ? $plan->storage_limit_gb . ' ' . __('GB') : __('Unlimited') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Coupons') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $plan->coupons->count() }} linked</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <p class="panel-heading">{{ __('Features') }}</p>
            <div class="mt-4 grid gap-3 sm:grid-cols-2 lg:grid-cols-3">
                @forelse ($plan->features ?? [] as $feature)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-3 text-sm text-ink">{{ $feature }}</div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/60 p-6 text-center text-sm text-muted">{{ __('No features listed for this plan.') }}</div>
                @endforelse
            </div>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Coupons') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Coupons applied to this plan.') }}</p>
                </div>
                <a href="{{ route('admin.coupons.index') }}" class="btn-secondary">{{ __('Manage Coupons') }}</a>
            </div>
            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @forelse ($plan->coupons as $coupon)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                        <p class="font-semibold text-ink">{{ $coupon->name }}</p>
                        <p class="mt-1 text-xs text-muted">{{ __('Code:') }} {{ $coupon->code }}</p>
                        <p class="mt-2 text-xs text-muted">
                            {{ ucfirst($coupon->discount_type) }}
                            {{ $coupon->discount_type === 'percent' ? $coupon->discount_value . '%' : \App\Support\FormatSettings::currency($coupon->discount_value) }}
                        </p>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/60 p-6 text-center text-sm text-muted">{{ __('No coupons linked to this plan.') }}</div>
                @endforelse
            </div>
        </div>
    </div>
</x-admin-layout>
