<x-admin-layout :title="__('Reports')" :subtitle="__('Filter, export, and print operational insights.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <p class="panel-heading">{{ __('Reporting Center') }}</p>
            <p class="mt-2 text-sm text-muted">{{ __('Generate CSV, Excel, or PDF exports for key business metrics. Use filters inside each report to narrow results.') }}</p>
        </div>

        <div class="panel p-6">
            <p class="text-lg font-semibold text-ink mb-4">{{ __('Activity Overview (Last 30 Days)') }}</p>
            <div id="overview-chart" class="w-full h-64"></div>
        </div>

        <div class="grid gap-4 md:grid-cols-2 xl:grid-cols-3">
            @foreach ($reports as $report)
                <div class="panel flex h-full flex-col p-6 hover:shadow-lg transition-shadow duration-200">
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ $report['title'] }}</p>
                        <p class="mt-2 text-sm text-muted line-clamp-2">{{ $report['description'] }}</p>
                    </div>
                    <div class="mt-auto pt-6 flex items-end justify-between">
                        <div>
                            <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Total records') }}</p>
                            <p class="mt-1 text-3xl font-semibold text-ink">{{ number_format($report['total']) }}</p>
                        </div>
                        <a href="{{ route('admin.reports.show', $report['key']) }}" class="btn-primary">{{ __('View Report') }}</a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const options = {
                series: @json($analytics['datasets']),
                chart: {
                    height: 350,
                    type: 'area',
                    toolbar: {
                        show: false
                    },
                    fontFamily: 'inherit'
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'smooth',
                    width: 2
                },
                xaxis: {
                    categories: @json($analytics['labels']),
                    axisBorder: {
                        show: false
                    },
                    axisTicks: {
                        show: false
                    }
                },
                tooltip: {
                    x: {
                        format: 'dd MMM'
                    },
                },
                colors: ['#3b82f6', '#10b981'],
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.45,
                        opacityTo: 0.05,
                        stops: [20, 100, 100, 100]
                    }
                },
            };

            const chart = new ApexCharts(document.querySelector("#overview-chart"), options);
            chart.render();
        });
    </script>
    @endpush
</x-admin-layout>
