<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>{{ $report['title'] }} Export</title>
        <style>
            body {
                font-family: DejaVu Sans, Arial, sans-serif;
                font-size: 11px;
                color: #111827;
            }
            h1 {
                font-size: 18px;
                margin-bottom: 4px;
            }
            p {
                margin: 0 0 8px;
                color: #6b7280;
            }
            table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 12px;
            }
            th,
            td {
                border: 1px solid #e5e7eb;
                padding: 6px 8px;
                text-align: left;
            }
            th {
                background: #f9fafb;
                font-size: 10px;
                text-transform: uppercase;
                letter-spacing: 0.12em;
            }
        </style>
    </head>
    <body>
        <h1>{{ $report['title'] }}</h1>
        <p>{{ $report['description'] }}</p>
        <p>Generated: {{ \App\Support\FormatSettings::dateTime($generatedAt) }}</p>

        <table>
            <thead>
                <tr>
                    @foreach ($columns as $column)
                        <th>{{ $column['label'] }}</th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @forelse ($rows as $row)
                    <tr>
                        @foreach ($columns as $column)
                            <td>{{ $row[$column['key']] ?? '-' }}</td>
                        @endforeach
                    </tr>
                @empty
                    <tr>
                        <td colspan="{{ count($columns) }}">{{ __('No data available.') }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </body>
</html>
