<x-admin-layout :title="$report['title']" :subtitle="$report['subtitle']">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ $report['title'] }}</p>
                    <p class="mt-2 text-sm text-muted">{{ $report['description'] }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.reports.export', array_merge(['report' => $reportKey, 'format' => 'csv'], request()->query())) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <a href="{{ route('admin.reports.export', array_merge(['report' => $reportKey, 'format' => 'xlsx'], request()->query())) }}" class="btn-secondary">{{ __('Export Excel') }}</a>
                    <a href="{{ route('admin.reports.export', array_merge(['report' => $reportKey, 'format' => 'pdf'], request()->query())) }}" class="btn-secondary">{{ __('Export PDF') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-6">
                @foreach ($filters['fields'] as $field)
                    <div>
                        <label class="sr-only" for="filter-{{ $field['name'] }}">{{ $field['label'] }}</label>
                        @if ($field['type'] === 'select')
                            <select id="filter-{{ $field['name'] }}" name="{{ $field['name'] }}" class="input-field">
                                @foreach ($field['options'] as $value => $label)
                                    <option value="{{ $value }}" @selected((string) $field['value'] === (string) $value)>{{ $label }}</option>
                                @endforeach
                            </select>
                        @else
                            @php
                                $inputType = $field['type'] === 'date' ? 'date' : 'text';
                            @endphp
                            <input
                                id="filter-{{ $field['name'] }}"
                                name="{{ $field['name'] }}"
                                type="{{ $inputType }}"
                                value="{{ $field['value'] }}"
                                placeholder="{{ $field['placeholder'] ?? '' }}"
                                class="input-field"
                            >
                        @endif
                    </div>
                @endforeach
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ $filters['reset'] }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        @if(count($charts) > 0)
        <div class="grid gap-6 md:grid-cols-2">
            @foreach($charts as $chart)
                <div class="panel p-6">
                    <p class="text-sm font-semibold text-ink mb-4">{{ $chart['title'] }}</p>
                    <div id="{{ $chart['id'] }}" class="w-full h-64"></div>
                </div>
            @endforeach
        </div>
        @endif

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ $report['title'] }} {{ __('Results') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing') }} {{ $rows->count() }} {{ __('of') }} {{ $rows->total() }} {{ __('records.') }}</p>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            @foreach ($report['columns'] as $column)
                                <th class="pb-3">{{ $column['label'] }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($rows as $row)
                            <tr>
                                @foreach ($report['columns'] as $column)
                                    <td class="py-3 text-sm text-ink">{{ $row[$column['key']] ?? '-' }}</td>
                                @endforeach
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ count($report['columns']) }}" class="py-6 text-center text-sm text-muted">
                                    {{ $report['empty'] }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6">
                {{ $rows->links() }}
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            @foreach($charts as $chart)
            (function() {
                const options = {
                    series: @json($chart['series']),
                    chart: {
                        height: 250,
                        type: '{{ $chart["type"] }}',
                        toolbar: { show: false },
                        fontFamily: 'inherit'
                    },
                    @if($chart['type'] === 'bar')
                    plotOptions: {
                        bar: {
                            borderRadius: 4,
                            horizontal: false,
                        }
                    },
                    xaxis: {
                        categories: @json($chart['labels']),
                    },
                    @else
                    labels: @json($chart['labels']),
                    legend: {
                        position: 'bottom'
                    },
                    @endif
                    colors: ['#3b82f6', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6', '#ec4899', '#14b8a6', '#f97316'],
                    dataLabels: { enabled: false },
                    theme: { mode: document.documentElement.classList.contains('dark') ? 'dark' : 'light' },
                    stroke: { width: '{{ $chart["type"] }}' === 'bar' ? 0 : 2 },
                };

                const chart = new ApexCharts(document.querySelector("#{{ $chart['id'] }}"), options);
                chart.render();
            })();
            @endforeach
        });
    </script>
    @endpush
</x-admin-layout>
