<x-admin-layout :title="__('Roles & Permissions')" :subtitle="__('Define access levels and map permissions per team.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Access Control') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Create roles, assign permissions, and track access coverage.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-roles')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/roles.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.permissions.index') }}" class="btn-secondary">{{ __('Manage Permissions') }}</a>
                    <a href="{{ route('admin.roles.create') }}" class="btn-primary">{{ __('Add Role') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.5fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search role names') }}">
                </div>
                <div>
                    <label class="sr-only" for="guard">{{ __('Guard') }}</label>
                    <select id="guard" name="guard" class="input-field">
                        <option value="">{{ __('All guards') }}</option>
                        @foreach ($guards as $guardOption)
                            <option value="{{ $guardOption }}" @selected($guard === $guardOption)>{{ $guardOption }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.roles.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="roles-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Roles') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing') }} {{ $roles->count() }} {{ __('of') }} {{ $roles->total() }} {{ __('roles.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.roles.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-role-bulk-delete">{{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Role') }}</th>
                            <th class="pb-3">{{ __('Guard') }}</th>
                            <th class="pb-3">{{ __('Members') }}</th>
                            <th class="pb-3">{{ __('Permissions') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($roles as $role)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $role->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $role->name }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $role->guard_name }}</td>
                                <td class="py-4 text-ink">{{ $role->users_count }}</td>
                                <td class="py-4 text-ink">{{ $role->permissions_count }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.roles.show', $role) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.roles.edit', $role) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-role-delete-{{ $role->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-role-delete-{{ $role->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.roles.destroy', $role) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete') }} {{ $role->name }}?</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-6 text-center text-sm text-muted">{{ __('No roles found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($roles as $role)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $role->name }}</p>
                                <p class="text-xs text-muted">{{ __('Guard:') }} {{ $role->guard_name }}</p>
                            </div>
                            <span class="badge">{{ $role->permissions_count }} {{ __('perms') }}</span>
                        </div>
                        <div class="mt-3 text-xs text-muted">{{ __('Members:') }} {{ $role->users_count }}</div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.roles.show', $role) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.roles.edit', $role) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No roles found.') }}</div>
                @endforelse
            </div>

            <x-modal name="confirm-role-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.roles.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected roles?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> role(s).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-roles" :show="false" focusable>
                <form method="POST" action="{{ route('admin.roles.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Roles') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="roles_file" :value="__('CSV File')" />
                        <input id="roles_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $roles->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
