@php
    $isEdit = isset($role) && $role;
    $selectedPermissions = old('permissions', $isEdit ? $role->permissions->pluck('id')->all() : []);
    $selectedGuard = old('guard_name', $isEdit ? $role->guard_name : 'web');
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Role Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="name" :value="__('Role Name')" />
                <x-text-input id="name" name="name" type="text" class="mt-1" :value="old('name', $isEdit ? $role->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="guard_name" :value="__('Guard Name')" />
                <select id="guard_name" name="guard_name" class="input-field mt-1">
                    @foreach ($guards as $guard)
                        <option value="{{ $guard }}" @selected((string) $selectedGuard === (string) $guard)>{{ $guard }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('guard_name')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6" x-data="{ 
        search: '',
        selectAll() {
            document.querySelectorAll('.permission-checkbox').forEach(cb => {
                const item = cb.closest('.permission-item');
                if (item && item.style.display !== 'none') {
                    cb.checked = true;
                }
            });
        },
        deselectAll() {
            document.querySelectorAll('.permission-checkbox').forEach(cb => {
                const item = cb.closest('.permission-item');
                if (item && item.style.display !== 'none') {
                    cb.checked = false;
                }
            });
        },
        toggleGroup(group, checked) {
            const checkboxes = document.querySelectorAll('.permission-checkbox[data-group=\'' + group + '\']');
            checkboxes.forEach(cb => {
                const item = cb.closest('.permission-item');
                if (item && item.style.display !== 'none') {
                    cb.checked = checked;
                }
            });
        }
    }">
        <div class="flex items-center justify-between gap-4">
            <div>
                <p class="panel-heading">{{ __('Permissions') }}</p>
                <p class="mt-2 text-sm text-muted">{{ __('Select permissions that match the chosen guard.') }}</p>
            </div>
            <div class="flex items-center gap-2">
                <button type="button" @click="selectAll()" class="text-xs font-semibold text-brand hover:underline">{{ __('Select All') }}</button>
                <span class="text-muted text-xs">/</span>
                <button type="button" @click="deselectAll()" class="text-xs font-semibold text-brand hover:underline">{{ __('Deselect All') }}</button>
            </div>
        </div>

        <div class="mt-4">
            <input type="text" x-model="search" placeholder="{{ __('Search permissions...') }}" class="input-field w-full">
        </div>

        <div class="mt-6 space-y-6 max-h-[600px] overflow-y-auto pr-2 custom-scrollbar">
            @forelse ($permissionGroups as $group => $items)
                <div class="permission-group-container" 
                     x-data="{ 
                        get hasVisible() {
                            if (!search) return true;
                            const term = search.toLowerCase();
                            @php
                                $names = $items->pluck('name')->map(fn($n) => strtolower($n))->toJson();
                            @endphp
                            return {{ $names }}.some(name => name.includes(term));
                        }
                     }" 
                     x-show="hasVisible">
                    <div class="flex items-center justify-between border-b border-border/40 pb-2">
                        <p class="text-xs font-semibold uppercase tracking-[0.2em] text-muted">{{ ucwords(str_replace(['_', '-'], ' ', $group)) }}</p>
                        <input type="checkbox" @change="toggleGroup('{{ $group }}', $event.target.checked)" class="h-4 w-4 rounded border-border text-brand focus:ring-brand/40" title="{{ __('Select all in group') }}">
                    </div>
                    <div class="mt-3 grid gap-3 text-sm text-muted sm:grid-cols-2">
                        @foreach ($items as $permission)
                            <label class="permission-item inline-flex items-center gap-2 transition-opacity duration-200" 
                                   x-show="!search || '{{ strtolower($permission->name) }}'.includes(search.toLowerCase())">
                                <input type="checkbox" name="permissions[]" value="{{ $permission->id }}" 
                                       data-group="{{ $group }}"
                                       class="permission-checkbox h-4 w-4 rounded border-border text-brand focus:ring-brand/40" 
                                       @checked(in_array($permission->id, $selectedPermissions, true))>
                                <span class="truncate">{{ $permission->name }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>
            @empty
                <p class="text-sm text-muted">{{ __('No permissions found. Add permissions first.') }}</p>
            @endforelse
        </div>
        @php
            $permissionErrors = array_merge($errors->get('permissions'), $errors->get('permissions.*'));
        @endphp
        <x-input-error :messages="$permissionErrors" class="mt-4" />
    </div>
</div>
