<x-admin-layout :title="__('Role Details')" :subtitle="__('Review role membership and permissions.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Role') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $role->name }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ __('Guard:') }} {{ $role->guard_name }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.roles.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.roles.edit', $role) }}" class="btn-primary">{{ __('Edit Role') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Members') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $role->users->count() }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Permissions') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $role->permissions->count() }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Last Updated') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::date($role->updated_at) }}</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Assigned Permissions') }}</p>
                    <p class="mt-2 text-sm text-muted">Permissions granted to {{ $role->name }}.</p>
                </div>
                <a href="{{ route('admin.permissions.index') }}" class="btn-secondary">{{ __('Manage Permissions') }}</a>
            </div>
            <div class="mt-6 grid gap-3 sm:grid-cols-2 lg:grid-cols-3">
                @forelse ($role->permissions as $permission)
                    <div class="rounded-xl border border-border/70 bg-surface-2/70 px-4 py-3 text-sm text-ink">
                        {{ $permission->name }}
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No permissions assigned yet.') }}</div>
                @endforelse
            </div>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Role Members') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Users assigned to this role.') }}</p>
                </div>
                <a href="{{ route('admin.users.index') }}" class="btn-secondary">{{ __('Manage Users') }}</a>
            </div>
            <div class="mt-6 grid gap-3 sm:grid-cols-2 lg:grid-cols-3">
                @forelse ($role->users as $user)
                    <div class="rounded-xl border border-border/70 bg-surface-2/70 px-4 py-3">
                        <p class="text-sm font-semibold text-ink">{{ $user->name }}</p>
                        <p class="text-xs text-muted">{{ $user->email }}</p>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No users assigned yet.') }}</div>
                @endforelse
            </div>
        </div>
    </div>
</x-admin-layout>
