@php
    $isEdit = isset($log) && $log;
@endphp

<div class="grid gap-6 lg:grid-cols-3">
    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Audit Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="event_type" :value="__('Event Type')" />
                <select id="event_type" name="event_type" class="input-field mt-1" required>
                    @foreach ($eventTypes as $value => $label)
                        <option value="{{ $value }}" @selected(old('event_type', $isEdit ? $log->event_type : '') === $value)>{{ $label }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('event_type')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="status" :value="__('Status')" />
                <select id="status" name="status" class="input-field mt-1" required>
                    @foreach ($statuses as $value => $label)
                        <option value="{{ $value }}" @selected(old('status', $isEdit ? $log->status : '') === $value)>{{ $label }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('status')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="user_id" :value="__('User')" />
                <select id="user_id" name="user_id" class="input-field mt-1">
                    <option value="">{{ __('System') }}</option>
                    @foreach ($users as $user)
                        <option value="{{ $user->id }}" @selected((string) old('user_id', $isEdit ? $log->user_id : '') === (string) $user->id)>{{ $user->name }} ({{ $user->email }})</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('user_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="ip_address" :value="__('IP Address')" />
                <x-text-input id="ip_address" name="ip_address" type="text" class="mt-1" :value="old('ip_address', $isEdit ? $log->ip_address : '')" />
                <x-input-error :messages="$errors->get('ip_address')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="user_agent" :value="__('User Agent')" />
                <x-text-input id="user_agent" name="user_agent" type="text" class="mt-1" :value="old('user_agent', $isEdit ? $log->user_agent : '')" />
                <x-input-error :messages="$errors->get('user_agent')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="metadata" :value="__('Metadata (JSON)')" />
                <textarea id="metadata" name="metadata" rows="4" class="input-field mt-1" data-no-wysiwyg>{{ old('metadata', $isEdit && $log->metadata ? json_encode($log->metadata) : '') }}</textarea>
                <x-input-error :messages="$errors->get('metadata')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Timing') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="logged_at" :value="__('Logged At')" />
                <x-text-input id="logged_at" name="logged_at" type="datetime-local" class="mt-1" :value="old('logged_at', $isEdit && $log->logged_at ? $log->logged_at->format('Y-m-d\\TH:i') : '')" />
                <x-input-error :messages="$errors->get('logged_at')" class="mt-2" />
            </div>
            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Created At')" />
                    <p class="mt-2 text-sm text-muted">{{ \App\Support\FormatSettings::dateTime($log->created_at) ?? '-' }}</p>
                </div>
            @endif
        </div>
    </div>
</div>
