<x-admin-layout :title="__('Security Audit Details')" :subtitle="__('Review security events and access decisions.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Audit Log') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $eventTypes[$log->event_type] ?? ucfirst($log->event_type) }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $statuses[$log->status] ?? ucfirst($log->status) }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.security-audit-logs.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.security-audit-logs.edit', $log) }}" class="btn-primary">{{ __('Edit Audit Log') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('User') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->user?->name ?? __('System') }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $log->user?->email ?? '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('IP Address') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->ip_address ?: '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Logged At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($log->logged_at) ?? '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-3">
                    <p class="panel-heading">{{ __('User Agent') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->user_agent ?: '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-3">
                    <p class="panel-heading">{{ __('Metadata') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">
                        {{ $log->metadata ? json_encode($log->metadata) : 'No metadata attached' }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
