﻿<x-admin-layout :title="__('Security & Compliance')" :subtitle="__('Control login protections, captcha, and two-factor policies.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Security Center') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Tune the guardrails protecting admin access.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.security-audit-logs.index') }}" class="btn-secondary">{{ __('View Audit Logs') }}</a>
                    <a href="{{ route('admin.blocked-ips.index') }}" class="btn-secondary">{{ __('Blocked IPs') }}</a>
                    <a href="{{ route('admin.blocked-locations.index') }}" class="btn-secondary">{{ __('Blocked Locations') }}</a>
                </div>
            </div>
        </div>

        <form method="POST" action="{{ route('admin.security-settings.update') }}" class="space-y-6">
            @csrf

            <div class="grid gap-6 lg:grid-cols-2">
                <div class="panel p-6">
                    <p class="panel-heading">{{ __('Login Protection') }}</p>
                    <div class="mt-4 grid gap-4">
                        <div>
                            <x-input-label for="max_login_attempts" :value="__('Max Login Attempts')" />
                            <x-text-input id="max_login_attempts" name="max_login_attempts" type="number" class="mt-1" min="1" max="20" :value="old('max_login_attempts', $settings['max_login_attempts'])" required />
                            <x-input-error :messages="$errors->get('max_login_attempts')" class="mt-2" />
                        </div>
                        <div>
                            <x-input-label for="lockout_minutes" :value="__('Lockout Duration (Minutes)')" />
                            <x-text-input id="lockout_minutes" name="lockout_minutes" type="number" class="mt-1" min="1" max="120" :value="old('lockout_minutes', $settings['lockout_minutes'])" required />
                            <x-input-error :messages="$errors->get('lockout_minutes')" class="mt-2" />
                        </div>
                    </div>
                </div>

                <div class="panel p-6">
                    <p class="panel-heading">{{ __('Captcha &amp; Two-Factor') }}</p>
                    <div class="mt-4 grid gap-4">
                        <div>
                            <x-input-label :value="__('Enable Google Captcha')" />
                            <input type="hidden" name="captcha_enabled" value="0">
                            <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                <input type="checkbox" name="captcha_enabled" value="1" class="peer sr-only" @checked((bool) old('captcha_enabled', $settings['captcha_enabled']))>
                                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                </span>
                                <span>{{ old('captcha_enabled', $settings['captcha_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                            </label>
                        </div>
                        <div>
                            <x-input-label for="captcha_site_key" :value="__('Captcha Site Key')" />
                            <x-text-input id="captcha_site_key" name="captcha_site_key" type="text" class="mt-1" :value="old('captcha_site_key', $settings['captcha_site_key'])" />
                            <x-input-error :messages="$errors->get('captcha_site_key')" class="mt-2" />
                        </div>
                        <div>
                            <x-input-label for="captcha_secret_key" :value="__('Captcha Secret Key')" />
                            <div class="relative mt-1">
                                <x-text-input id="captcha_secret_key" name="captcha_secret_key" type="password" class="pr-12" :value="old('captcha_secret_key', $settings['captcha_secret_key'])" />
                                <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="captcha_secret_key" aria-label="Toggle secret visibility">
                                    <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                                        <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                    <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                                        <path d="M3 5l16 16"></path>
                                        <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                                        <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                                        <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                                    </svg>
                                </button>
                            </div>
                            <x-input-error :messages="$errors->get('captcha_secret_key')" class="mt-2" />
                        </div>
                        <div>
                            <x-input-label :value="__('Require 2FA for Admin Roles')" />
                            <input type="hidden" name="two_factor_admin_only" value="0">
                            <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                <input type="checkbox" name="two_factor_admin_only" value="1" class="peer sr-only" @checked((bool) old('two_factor_admin_only', $settings['two_factor_admin_only']))>
                                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                </span>
                                <span>{{ old('two_factor_admin_only', $settings['two_factor_admin_only']) ? __('Required') : __('Optional') }}</span>
                            </label>
                            @if ($adminRoles)
                                <p class="mt-2 text-xs text-muted">Admin roles: {{ implode(', ', $adminRoles) }}</p>
                            @endif
                        </div>
                        <div>
                            <x-input-label for="two_factor_issuer" :value="__('2FA Issuer Name')" />
                            <x-text-input id="two_factor_issuer" name="two_factor_issuer" type="text" class="mt-1" :value="old('two_factor_issuer', $settings['two_factor_issuer'])" />
                            <x-input-error :messages="$errors->get('two_factor_issuer')" class="mt-2" />
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <button type="submit" class="btn-primary">{{ __('Save Security Settings') }}</button>
            </div>
        </form>

        <div class="panel p-6">
            <p class="panel-heading">{{ __('Admin Two-Factor Authentication') }}</p>
            <p class="mt-2 text-sm text-muted">{{ __('Manage two-factor authentication for your account.') }}</p>

            @if ($twoFactorEnabled)
                <div class="mt-4 space-y-4" x-data="{ confirmDisable: false }">
                    <div class="flex flex-wrap items-center justify-between gap-3">
                        <span class="badge">{{ __('Enabled') }}</span>
                        <button type="button" class="btn-danger" @click="confirmDisable = !confirmDisable" x-text="confirmDisable ? 'Cancel' : 'Disable 2FA'"></button>
                    </div>
                    <div x-show="confirmDisable" x-cloak class="rounded-xl border border-danger/20 bg-danger/5 p-4">
                        <p class="text-sm font-medium text-ink">{{ __('Confirm your password to disable two-factor authentication.') }}</p>
                        <form method="POST" action="{{ route('admin.security-settings.two-factor.disable') }}" class="mt-3 flex items-end gap-3">
                            @csrf
                            <div class="flex-1">
                                <x-input-label for="current_password" :value="__('Current Password')" />
                                <x-text-input id="current_password" name="current_password" type="password" class="mt-1" required />
                                <x-input-error :messages="$errors->get('current_password')" class="mt-2" />
                            </div>
                            <x-danger-button type="submit">{{ __('Confirm Disable') }}</x-danger-button>
                        </form>
                    </div>
                </div>
            @else
                <div class="mt-6 flex flex-col items-center gap-6 sm:flex-row sm:items-start">
                    {{-- QR Code --}}
                    <div class="shrink-0 rounded-2xl border border-border bg-white p-3 shadow-soft">
                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=192x192&data={{ urlencode($twoFactorOtpAuthUrl) }}" alt="2FA QR Code" width="192" height="192" class="rounded-lg" />
                    </div>
                    {{-- Instructions + form --}}
                    <div class="flex-1 min-w-0 space-y-4">
                        <div>
                            <p class="text-sm font-semibold text-ink">{{ __('Scan QR Code') }}</p>
                            <p class="mt-1 text-xs text-muted">{{ __('Open your authenticator app (Google Authenticator, Authy, etc.) and scan the QR code. Then enter the 6-digit code below.') }}</p>
                        </div>
                        {{-- Manual entry fallback --}}
                        <div x-data="{ showManual: false }">
                            <button type="button" class="text-xs font-medium text-brand hover:underline" @click="showManual = !showManual" x-text="showManual ? 'Hide manual key' : 'Can\'t scan? Enter key manually'"></button>
                            <div x-show="showManual" x-cloak class="mt-2 rounded-xl border border-border bg-surface-2 p-3">
                                <p class="text-[10px] font-bold uppercase tracking-widest text-muted">{{ __('Secret Key') }}</p>
                                <p class="mt-1 select-all break-all font-mono text-sm text-ink">{{ $twoFactorSecret }}</p>
                            </div>
                        </div>
                        <form method="POST" action="{{ route('admin.security-settings.two-factor.enable') }}" class="flex items-end gap-3">
                            @csrf
                            <div class="flex-1">
                                <x-input-label for="two_factor_code" :value="__('Verification Code')" />
                                <x-text-input id="two_factor_code" name="code" type="text" class="mt-1" placeholder="000000" inputmode="numeric" autocomplete="one-time-code" maxlength="6" required />
                                <x-input-error :messages="$errors->get('code')" class="mt-2" />
                                @if (session('error'))
                                    <p class="mt-2 text-sm text-danger">{{ session('error') }}</p>
                                @endif
                            </div>
                            <x-primary-button type="submit">Enable 2FA</x-primary-button>
                        </form>
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-admin-layout>

