<x-admin-layout :title="__('Blocked IPs')" :subtitle="__('Block unwanted IP addresses from accessing the admin.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Security Controls') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Maintain a denylist of IP addresses and CIDR ranges.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-blocked-ips')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/blocked-ips.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.blocked-ips.create') }}" class="btn-primary">{{ __('Add Blocked IP') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.6fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search IP or reason') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                        <option value="ip_asc" @selected($sort === 'ip_asc')>{{ __('IP (A-Z)') }}</option>
                        <option value="ip_desc" @selected($sort === 'ip_desc')>{{ __('IP (Z-A)') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.blocked-ips.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="blocked-ips-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Blocked IP Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Showing {{ $blockedIps->count() }} of {{ $blockedIps->total() }} blocked entries.</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.blocked-ips.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-blocked-ip-bulk-delete">{{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('IP Address') }}</th>
                            <th class="pb-3">{{ __('Reason') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Created By') }}</th>
                            <th class="pb-3">{{ __('Created') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($blockedIps as $blockedIp)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $blockedIp->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $blockedIp->ip_address }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $blockedIp->reason ?: '-' }}</td>
                                <td class="py-4 text-sm text-ink">{{ $blockedIp->is_active ? __('Active') : __('Inactive') }}</td>
                                <td class="py-4 text-sm text-ink">{{ $blockedIp->creator?->name ?? __('System') }}</td>
                                <td class="py-4 text-sm text-ink">{{ \App\Support\FormatSettings::dateTime($blockedIp->created_at) ?? '-' }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.blocked-ips.show', $blockedIp) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.blocked-ips.edit', $blockedIp) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-blocked-ip-delete-{{ $blockedIp->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-blocked-ip-delete-{{ $blockedIp->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.blocked-ips.destroy', $blockedIp) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete this blocked IP?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="py-6 text-center text-sm text-muted">{{ __('No blocked IPs found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($blockedIps as $blockedIp)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $blockedIp->ip_address }}</p>
                                <p class="text-xs text-muted">{{ $blockedIp->reason ?: __('No reason provided') }}</p>
                            </div>
                            <span class="badge">{{ $blockedIp->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-3 text-xs text-muted">{{ __('By') }} {{ $blockedIp->creator?->name ?? __('System') }}</div>
                        <div class="mt-1 text-xs text-muted">{{ \App\Support\FormatSettings::dateTime($blockedIp->created_at) ?? '-' }}</div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.blocked-ips.show', $blockedIp) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.blocked-ips.edit', $blockedIp) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No blocked IPs found.') }}</div>
                @endforelse
            </div>

            <x-modal name="confirm-blocked-ip-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blocked-ips.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected blocked IPs?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> blocked IP(s).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-blocked-ips" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blocked-ips.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Blocked IPs') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="blocked_ips_file" :value="__('CSV File')" />
                        <input id="blocked_ips_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $blockedIps->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
