﻿@php
    $isEdit = isset($blockedIp) && $blockedIp;
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('IP Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="ip_address" :value="__('IP Address / CIDR')" />
                <x-text-input id="ip_address" name="ip_address" type="text" class="mt-1" :value="old('ip_address', $isEdit ? $blockedIp->ip_address : '')" required />
                <p class="mt-2 text-xs text-muted">{{ __('Examples: 203.0.113.10, 203.0.113.0/24, 2001:db8::/32') }}</p>
                <x-input-error :messages="$errors->get('ip_address')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="reason" :value="__('Reason')" />
                <x-text-input id="reason" name="reason" type="text" class="mt-1" :value="old('reason', $isEdit ? $blockedIp->reason : '')" placeholder="{{ __('Suspicious access attempts') }}" />
                <x-input-error :messages="$errors->get('reason')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status & Metadata') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label :value="__('Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $blockedIp->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $blockedIp->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Created By')" />
                    <p class="mt-2 text-sm text-muted">{{ $blockedIp->creator?->name ?? __('System') }}</p>
                </div>
                <div>
                    <x-input-label :value="__('Created At')" />
                    <p class="mt-2 text-sm text-muted">{{ \App\Support\FormatSettings::dateTime($blockedIp->created_at) ?? '-' }}</p>
                </div>
            @endif
        </div>
    </div>
</div>

