<x-admin-layout :title="__('Blocked IP Details')" :subtitle="__('Review blocked access entries.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Blocked IP') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $blockedIp->ip_address }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $blockedIp->reason ?: __('No reason provided') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.blocked-ips.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.blocked-ips.edit', $blockedIp) }}" class="btn-primary">{{ __('Edit Blocked IP') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $blockedIp->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created By') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $blockedIp->creator?->name ?? __('System') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($blockedIp->created_at) ?? '-' }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
