<x-admin-layout :title="__('Blocked Locations')" :subtitle="__('Restrict admin access by country, state, or city.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Regional Controls') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Maintain location rules for sensitive regions.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-blocked-locations')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/blocked-locations.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.blocked-locations.create') }}" class="btn-primary">{{ __('Add Blocked Location') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.5fr,1fr,1fr,1fr,1fr,auto] sm:grid-cols-2" data-location-scope>
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search reason or notes') }}">
                </div>
                <div>
                    <label class="sr-only" for="country_id">{{ __('Country') }}</label>
                    <select id="country_id" name="country_id" class="input-field" data-country-select>
                        <option value="">{{ __('All countries') }}</option>
                        @foreach ($countries as $country)
                            <option value="{{ $country->id }}" @selected((string) $countryId === (string) $country->id)>{{ $country->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="state_id">{{ __('State') }}</label>
                    <select id="state_id" name="state_id" class="input-field" data-state-select>
                        <option value="">{{ __('All states') }}</option>
                        @foreach ($states as $state)
                            <option value="{{ $state->id }}" data-country-id="{{ $state->country_id }}" @selected((string) $stateId === (string) $state->id)>{{ $state->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="city_id">{{ __('City') }}</label>
                    <select id="city_id" name="city_id" class="input-field" data-city-select>
                        <option value="">{{ __('All cities') }}</option>
                        @foreach ($cities as $city)
                            <option value="{{ $city->id }}" data-state-id="{{ $city->state_id }}" @selected((string) $cityId === (string) $city->id)>{{ $city->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                        <option value="location_asc" @selected($sort === 'location_asc')>{{ __('Location (A-Z)') }}</option>
                        <option value="location_desc" @selected($sort === 'location_desc')>{{ __('Location (Z-A)') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.blocked-locations.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="blocked-locations-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Blocked Location Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">Showing {{ $blockedLocations->count() }} of {{ $blockedLocations->total() }} blocked entries.</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.blocked-locations.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-blocked-location-bulk-delete">{{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Location') }}</th>
                            <th class="pb-3">{{ __('Reason') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Created By') }}</th>
                            <th class="pb-3">{{ __('Created') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($blockedLocations as $blockedLocation)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $blockedLocation->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $blockedLocation->country?->name ?? __('Any Country') }}</p>
                                    <p class="text-xs text-muted">{{ $blockedLocation->state?->name ?? __('Any State') }} - {{ $blockedLocation->city?->name ?? __('Any City') }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $blockedLocation->reason ?: '-' }}</td>
                                <td class="py-4 text-sm text-ink">{{ $blockedLocation->is_active ? __('Active') : __('Inactive') }}</td>
                                <td class="py-4 text-sm text-ink">{{ $blockedLocation->creator?->name ?? __('System') }}</td>
                                <td class="py-4 text-sm text-ink">{{ \App\Support\FormatSettings::dateTime($blockedLocation->created_at) ?? '-' }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.blocked-locations.show', $blockedLocation) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.blocked-locations.edit', $blockedLocation) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-blocked-location-delete-{{ $blockedLocation->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-blocked-location-delete-{{ $blockedLocation->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.blocked-locations.destroy', $blockedLocation) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete this blocked location?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="py-6 text-center text-sm text-muted">{{ __('No blocked locations found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($blockedLocations as $blockedLocation)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $blockedLocation->country?->name ?? __('Any Country') }}</p>
                                <p class="text-xs text-muted">{{ $blockedLocation->state?->name ?? __('Any State') }}</p>
                                <p class="text-xs text-muted">{{ $blockedLocation->city?->name ?? __('Any City') }}</p>
                            </div>
                            <span class="badge">{{ $blockedLocation->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-3 text-xs text-muted">{{ $blockedLocation->reason ?: __('No reason provided') }}</div>
                        <div class="mt-2 text-xs text-muted">{{ __('By') }} {{ $blockedLocation->creator?->name ?? __('System') }}</div>
                        <div class="mt-1 text-xs text-muted">{{ \App\Support\FormatSettings::dateTime($blockedLocation->created_at) ?? '-' }}</div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.blocked-locations.show', $blockedLocation) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.blocked-locations.edit', $blockedLocation) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No blocked locations found.') }}</div>
                @endforelse
            </div>

            <x-modal name="confirm-blocked-location-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blocked-locations.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected blocked locations?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> blocked location(s).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-blocked-locations" :show="false" focusable>
                <form method="POST" action="{{ route('admin.blocked-locations.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Blocked Locations') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="blocked_locations_file" :value="__('CSV File')" />
                        <input id="blocked_locations_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $blockedLocations->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
