﻿@php
    $isEdit = isset($blockedLocation) && $blockedLocation;
    $selectedCountry = old('country_id', $isEdit ? $blockedLocation->country_id : null);
    $selectedState = old('state_id', $isEdit ? $blockedLocation->state_id : null);
    $selectedCity = old('city_id', $isEdit ? $blockedLocation->city_id : null);
@endphp

<div class="grid gap-6 lg:grid-cols-2" data-location-scope>
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Location Scope') }}</p>
        <p class="mt-2 text-sm text-muted">{{ __('Select at least one level to block access.') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="country_id" :value="__('Country')" />
                <select id="country_id" name="country_id" class="input-field mt-1" data-country-select>
                    <option value="">{{ __('Select country') }}</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}" @selected((string) $selectedCountry === (string) $country->id)>{{ $country->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('country_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="state_id" :value="__('State')" />
                <select id="state_id" name="state_id" class="input-field mt-1" data-state-select>
                    <option value="">{{ __('Select state') }}</option>
                    @foreach ($states as $state)
                        <option value="{{ $state->id }}" data-country-id="{{ $state->country_id }}" @selected((string) $selectedState === (string) $state->id)>{{ $state->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('state_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="city_id" :value="__('City')" />
                <select id="city_id" name="city_id" class="input-field mt-1" data-city-select>
                    <option value="">{{ __('Select city') }}</option>
                    @foreach ($cities as $city)
                        <option value="{{ $city->id }}" data-state-id="{{ $city->state_id }}" @selected((string) $selectedCity === (string) $city->id)>{{ $city->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('city_id')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status & Notes') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="reason" :value="__('Reason')" />
                <x-text-input id="reason" name="reason" type="text" class="mt-1" :value="old('reason', $isEdit ? $blockedLocation->reason : '')" placeholder="{{ __('Blocked region policy') }}" />
                <x-input-error :messages="$errors->get('reason')" class="mt-2" />
            </div>
            <div>
                <x-input-label :value="__('Status')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $blockedLocation->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $blockedLocation->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Created By')" />
                    <p class="mt-2 text-sm text-muted">{{ $blockedLocation->creator?->name ?? __('System') }}</p>
                </div>
                <div>
                    <x-input-label :value="__('Created At')" />
                    <p class="mt-2 text-sm text-muted">{{ \App\Support\FormatSettings::dateTime($blockedLocation->created_at) ?? '-' }}</p>
                </div>
            @endif
        </div>
    </div>
</div>

