<x-admin-layout :title="__('Blocked Location Details')" :subtitle="__('Review restricted regions and access notes.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Blocked Location') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">
                        {{ $blockedLocation->country?->name ?? __('Any Country') }}
                    </h2>
                    <p class="mt-1 text-sm text-muted">
                        {{ $blockedLocation->state?->name ?? __('Any State') }} - {{ $blockedLocation->city?->name ?? __('Any City') }}
                    </p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.blocked-locations.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.blocked-locations.edit', $blockedLocation) }}" class="btn-primary">{{ __('Edit Blocked Location') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $blockedLocation->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created By') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $blockedLocation->creator?->name ?? __('System') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Created At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ \App\Support\FormatSettings::dateTime($blockedLocation->created_at) ?? '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 lg:col-span-3">
                    <p class="panel-heading">{{ __('Reason') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $blockedLocation->reason ?: __('No reason provided') }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
