﻿<x-admin-layout :title="__('Support Tickets')" :subtitle="__('Track client issues, priorities, and resolution timelines.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Support') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Keep customer questions organized and assigned.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-support-tickets')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/support-tickets.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.support-tickets.create') }}" class="btn-primary">{{ __('Add Ticket') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.4fr,1fr,1fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search by ticket, subject, or requester') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        @foreach ($statuses as $value => $label)
                            <option value="{{ $value }}" @selected($status === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="priority">{{ __('Priority') }}</label>
                    <select id="priority" name="priority" class="input-field">
                        <option value="">{{ __('All priorities') }}</option>
                        @foreach ($priorities as $value => $label)
                            <option value="{{ $value }}" @selected($priority === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="assignee">{{ __('Assignee') }}</label>
                    <select id="assignee" name="assignee" class="input-field">
                        <option value="">{{ __('All assignees') }}</option>
                        @foreach ($agents as $agent)
                            <option value="{{ $agent->id }}" @selected((string) $assignee === (string) $agent->id)>{{ $agent->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                        <option value="subject_asc" @selected($sort === 'subject_asc')>{{ __('Subject (A-Z)') }}</option>
                        <option value="subject_desc" @selected($sort === 'subject_desc')>{{ __('Subject (Z-A)') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.support-tickets.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="support-tickets-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Ticket Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing') }} {{ $tickets->count() }} {{ __('of') }} {{ $tickets->total() }} {{ __('tickets.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.support-tickets.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-support-ticket-bulk-delete">{{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Ticket') }}</th>
                            <th class="pb-3">{{ __('Requester') }}</th>
                            <th class="pb-3">{{ __('Priority') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Assignee') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($tickets as $ticket)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $ticket->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $ticket->subject }}</p>
                                    <p class="text-xs text-muted">{{ $ticket->ticket_number }}</p>
                                </td>
                                <td class="py-4">
                                    <p class="text-sm text-ink">{{ $ticket->requester_name }}</p>
                                    <p class="text-xs text-muted">{{ $ticket->requester_email }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $priorities[$ticket->priority] ?? ucfirst($ticket->priority) }}</td>
                                <td class="py-4 text-sm text-ink">{{ $statuses[$ticket->status] ?? ucfirst(str_replace('_', ' ', $ticket->status)) }}</td>
                                <td class="py-4 text-sm text-ink">{{ $ticket->currentAssignment?->assignedTo?->name ?? __('Unassigned') }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.support-tickets.show', $ticket) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.support-tickets.edit', $ticket) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-support-ticket-delete-{{ $ticket->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-support-ticket-delete-{{ $ticket->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.support-tickets.destroy', $ticket) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete') }} {{ $ticket->subject }}?</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="py-6 text-center text-sm text-muted">{{ __('No tickets found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($tickets as $ticket)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $ticket->subject }}</p>
                                <p class="text-xs text-muted">{{ $ticket->ticket_number }}</p>
                            </div>
                            <span class="badge">{{ $statuses[$ticket->status] ?? ucfirst(str_replace('_', ' ', $ticket->status)) }}</span>
                        </div>
                        <div class="mt-3 text-sm text-ink">{{ $ticket->requester_name }}</div>
                        <div class="mt-1 text-xs text-muted">{{ $ticket->requester_email }}</div>
                        <div class="mt-3 flex flex-wrap gap-2">
                            <span class="badge">{{ $priorities[$ticket->priority] ?? ucfirst($ticket->priority) }}</span>
                            <span class="badge">{{ $ticket->currentAssignment?->assignedTo?->name ?? __('Unassigned') }}</span>
                        </div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.support-tickets.show', $ticket) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.support-tickets.edit', $ticket) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No tickets found.') }}</div>
                @endforelse
            </div>

            <x-modal name="confirm-support-ticket-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.support-tickets.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected tickets?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> ticket(s).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-support-tickets" :show="false" focusable>
                <form method="POST" action="{{ route('admin.support-tickets.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Support Tickets') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="support_ticket_file" :value="__('CSV File')" />
                        <input id="support_ticket_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $tickets->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
