﻿@php
    $isEdit = isset($ticket) && $ticket;
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Ticket Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="subject" :value="__('Subject')" />
                <x-text-input id="subject" name="subject" type="text" class="mt-1" :value="old('subject', $isEdit ? $ticket->subject : '')" required />
                <x-input-error :messages="$errors->get('subject')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="message" :value="__('Message')" />
                <textarea id="message" name="message" rows="6" class="input-field mt-1" required>{{ old('message', $isEdit ? $ticket->message : '') }}</textarea>
                <x-input-error :messages="$errors->get('message')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Requester Info') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="requester_name" :value="__('Full Name')" />
                <x-text-input id="requester_name" name="requester_name" type="text" pattern="[A-Za-z][A-Za-z\s.'-]{0,39}" maxlength="40" class="mt-1" :value="old('requester_name', $isEdit ? $ticket->requester_name : '')" required />
                <x-input-error :messages="$errors->get('requester_name')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="requester_email" :value="__('Email')" />
                <x-text-input id="requester_email" name="requester_email" type="email" maxlength="30" class="mt-1" :value="old('requester_email', $isEdit ? $ticket->requester_email : '')" required />
                <x-input-error :messages="$errors->get('requester_email')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="requester_phone" :value="__('Mobile Number')" />
                <x-text-input id="requester_phone" name="requester_phone" type="text" inputmode="tel" pattern="\+?[0-9]{1,15}" maxlength="15" data-phone-input class="mt-1" :value="old('requester_phone', $isEdit ? $ticket->requester_phone : '')" placeholder="{{ __('+91XXXXXXXXXX') }}" />
                <x-input-error :messages="$errors->get('requester_phone')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Priority & Status') }}</p>
        <div class="mt-4 grid gap-4 lg:grid-cols-3">
            <div>
                <x-input-label for="priority" :value="__('Priority')" />
                <select id="priority" name="priority" class="input-field mt-1" required>
                    @foreach ($priorities as $value => $label)
                        <option value="{{ $value }}" @selected(old('priority', $isEdit ? $ticket->priority : 'medium') === $value)>{{ $label }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('priority')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="status" :value="__('Status')" />
                <select id="status" name="status" class="input-field mt-1" required>
                    @foreach ($statuses as $value => $label)
                        <option value="{{ $value }}" @selected(old('status', $isEdit ? $ticket->status : 'open') === $value)>{{ $label }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('status')" class="mt-2" />
            </div>
            <div>
                <x-input-label :value="__('Active')" />
                <input type="hidden" name="is_active" value="0">
                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                    <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $ticket->is_active : true))>
                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                    </span>
                    <span>{{ old('is_active', $isEdit ? $ticket->is_active : true) ? __('Active') : __('Inactive') }}</span>
                </label>
            </div>
        </div>
    </div>
</div>

