﻿<x-admin-layout :title="__('Ticket Details')" :subtitle="__('Review requester details, status, and assignment history.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Ticket') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $ticket->subject }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $ticket->ticket_number }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.support-tickets.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.support-tickets.edit', $ticket) }}" class="btn-primary">{{ __('Edit Ticket') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Priority') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $priorities[$ticket->priority] ?? ucfirst($ticket->priority) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $statuses[$ticket->status] ?? ucfirst(str_replace('_', ' ', $ticket->status)) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Assignee') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $ticket->currentAssignment?->assignedTo?->name ?? __('Unassigned') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Resolved') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $ticket->resolved_at ? \App\Support\FormatSettings::dateTime($ticket->resolved_at) : __('Not resolved') }}</p>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-2">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Requester') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $ticket->requester_name }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $ticket->requester_email }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $ticket->requester_phone ?: __('No phone provided') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Message') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ $ticket->message }}</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Ticket Assignment') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Assign this ticket to a support agent.') }}</p>
                </div>
            </div>
            <form method="POST" action="{{ route('admin.ticket-assignments.store') }}" class="mt-6 grid gap-4 lg:grid-cols-[1fr,1fr,1.5fr,auto]">
                @csrf
                <input type="hidden" name="support_ticket_id" value="{{ $ticket->id }}">
                <div>
                    <x-input-label for="assigned_to" :value="__('Assign To')" />
                    <select id="assigned_to" name="assigned_to" class="input-field mt-1" required>
                        <option value="">{{ __('Select agent') }}</option>
                        @foreach ($agents as $agent)
                            <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                        @endforeach
                    </select>
                    <x-input-error :messages="$errors->get('assigned_to')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="assigned_at" :value="__('Assigned At')" />
                    <x-text-input id="assigned_at" name="assigned_at" type="datetime-local" class="mt-1" />
                    <x-input-error :messages="$errors->get('assigned_at')" class="mt-2" />
                </div>
                <div>
                    <x-input-label for="note" :value="__('Note')" />
                    <x-text-input id="note" name="note" type="text" class="mt-1" placeholder="{{ __('Assignment details') }}" />
                    <x-input-error :messages="$errors->get('note')" class="mt-2" />
                </div>
                <div class="flex items-end gap-3">
                    <input type="hidden" name="is_active" value="0">
                    <label class="inline-flex items-center gap-2 text-sm text-muted">
                        <input type="checkbox" name="is_active" value="1" class="h-4 w-4 rounded border-border text-brand focus:ring-brand/40" checked>
                        Active
                    </label>
                    <button type="submit" class="btn-primary">{{ __('Assign') }}</button>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope>
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Assignment History') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing') }} {{ $ticket->assignments->count() }} {{ __('assignment(s).') }}</p>
                </div>
                <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-assignment-bulk-delete">{{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                </button>
            </div>
            <div class="mt-6 overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Assignee') }}</th>
                            <th class="pb-3">{{ __('Assigned At') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Note') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($ticket->assignments as $assignment)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $assignment->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $assignment->assignedTo?->name ?? __('Unassigned') }}</p>
                                    <p class="text-xs text-muted">{{ $assignment->assignedTo?->email ?? __('N/A') }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $assignment->assigned_at ? \App\Support\FormatSettings::dateTime($assignment->assigned_at) : __('Not set') }}</td>
                                <td class="py-4 text-sm text-ink">{{ $assignment->is_active ? __('Active') : __('Inactive') }}</td>
                                <td class="py-4 text-sm text-ink">{{ $assignment->note ?: '-' }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.ticket-assignments.edit', $assignment) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-assignment-delete-{{ $assignment->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-assignment-delete-{{ $assignment->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.ticket-assignments.destroy', $assignment) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete assignment?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="py-6 text-center text-sm text-muted">{{ __('No assignments yet.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <x-modal name="confirm-assignment-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.ticket-assignments.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected assignments?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> assignment(s).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>
        </div>
    </div>
</x-admin-layout>
