<x-admin-layout :title="'System Hub'" :subtitle="'Pages, extensions, security, and monitoring'">

    <div class="space-y-8">
        {{-- Configuration --}}
        <div>
            <p class="panel-heading mb-4">{{ __('Configuration') }}</p>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @can('viewAny', \App\Models\Page::class)
                <a href="{{ route('admin.pages.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M6 3h9l3 3v15a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2z"></path>
                            <path d="M9 9h6"></path>
                            <path d="M9 13h6"></path>
                            <path d="M9 17h3"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Pages') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage dynamic and static pages.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\ExtensionSetting::class)
                <a href="{{ route('admin.extensions.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-frontend">{{ __('Frontend') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M9 12h6"></path>
                            <path d="M12 9v6"></path>
                            <rect x="4" y="4" width="16" height="16" rx="3"></rect>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Extensions') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Analytics, AdSense, Meta Pixel, and integrations.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan
            </div>
        </div>

        {{-- Security & Access --}}
        <div>
            <p class="panel-heading mb-4">{{ __('Security Access') }}</p>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @can('viewAny', \App\Models\BlockedIp::class)
                <a href="{{ route('admin.blocked-ips.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-both">{{ __('Both') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="9"></circle>
                            <path d="M5.7 5.7l12.6 12.6"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Blocked IPs') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Manage IP address blocking rules.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\BlockedLocation::class)
                <a href="{{ route('admin.blocked-locations.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-both">{{ __('Both') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 10c0 6-9 11-9 11s-9-5-9-11a9 9 0 0 1 18 0z"></path>
                            <circle cx="12" cy="10" r="3"></circle>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Blocked Locations') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Block access from specific geographic regions.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan
            </div>
        </div>

        {{-- Logs & Monitoring --}}
        <div>
            <p class="panel-heading mb-4">{{ __('Logs &amp; Monitoring') }}</p>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @can('viewAny', \App\Models\ActivityLog::class)
                <a href="{{ route('admin.activity-logs.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-admin">{{ __('Admin') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 19h16"></path>
                            <path d="M6 16l3-4 4 3 5-7"></path>
                            <circle cx="6" cy="16" r="1"></circle>
                            <circle cx="9" cy="12" r="1"></circle>
                            <circle cx="13" cy="15" r="1"></circle>
                            <circle cx="18" cy="8" r="1"></circle>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Activity Logs') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Track user actions and system activities.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\SystemLog::class)
                <a href="{{ route('admin.system-logs.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-admin">{{ __('Admin') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 4h16v16H4z"></path>
                            <path d="M8 8h8"></path>
                            <path d="M8 12h8"></path>
                            <path d="M8 16h5"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('System Logs') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('View application error and debug logs.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan

                @can('viewAny', \App\Models\SecurityAuditLog::class)
                <a href="{{ route('admin.security-audit-logs.index') }}" class="hub-card group">
                    <span class="scope-badge scope-badge-admin">{{ __('Admin') }}</span>
                    <div class="hub-card-icon">
                        <svg viewBox="0 0 24 24" class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 3l7 4v5c0 4.2-3 7.9-7 9-4-1.1-7-4.8-7-9V7l7-4z"></path>
                            <path d="M8 12h8"></path>
                        </svg>
                    </div>
                    <div class="min-w-0 flex-1">
                        <p class="font-semibold text-ink group-hover:text-brand transition-colors">{{ __('Security Audit Logs') }}</p>
                        <p class="mt-1 text-sm text-muted">{{ __('Review security events and authentication logs.') }}</p>
                    </div>
                    <svg viewBox="0 0 24 24" class="h-5 w-5 shrink-0 text-muted/50 transition group-hover:text-brand" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                </a>
                @endcan
            </div>
        </div>
    </div>

</x-admin-layout>
