@php
    $isEdit = isset($log) && $log;
@endphp

<div class="grid gap-6 lg:grid-cols-3">
    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Log Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="level" :value="__('Level')" />
                <select id="level" name="level" class="input-field mt-1" required>
                    @foreach ($levels as $value => $label)
                        <option value="{{ $value }}" @selected(old('level', $isEdit ? $log->level : '') === $value)>{{ $label }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('level')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="source" :value="__('Source')" />
                <x-text-input id="source" name="source" type="text" class="mt-1" :value="old('source', $isEdit ? $log->source : '')" placeholder="{{ __('queue, api, scheduler') }}" />
                <x-input-error :messages="$errors->get('source')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="message" :value="__('Message')" />
                <textarea id="message" name="message" rows="4" class="input-field mt-1" data-no-wysiwyg required>{{ old('message', $isEdit ? $log->message : '') }}</textarea>
                <x-input-error :messages="$errors->get('message')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="context" :value="__('Context (JSON)')" />
                <textarea id="context" name="context" rows="4" class="input-field mt-1" data-no-wysiwyg>{{ old('context', $isEdit && $log->context ? json_encode($log->context) : '') }}</textarea>
                <x-input-error :messages="$errors->get('context')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Timing') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="logged_at" :value="__('Logged At')" />
                <x-text-input id="logged_at" name="logged_at" type="datetime-local" class="mt-1" :value="old('logged_at', $isEdit && $log->logged_at ? $log->logged_at->format('Y-m-d\\TH:i') : '')" />
                <x-input-error :messages="$errors->get('logged_at')" class="mt-2" />
            </div>
            @if ($isEdit)
                <div>
                    <x-input-label :value="__('Created By')" />
                    <p class="mt-2 text-sm text-muted">{{ $log->createdBy?->name ?? __('System') }}</p>
                </div>
            @endif
        </div>
    </div>
</div>
