<x-admin-layout :title="__('System Log Details')" :subtitle="__('Review log metadata and context.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Log Entry') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $log->message }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $levels[$log->level] ?? ucfirst($log->level) }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.system-logs.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.system-logs.edit', $log) }}" class="btn-primary">{{ __('Edit Log') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Level') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $levels[$log->level] ?? ucfirst($log->level) }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Source') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->source ?: __('System') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Logged At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->logged_at ? \App\Support\FormatSettings::dateTime($log->logged_at) : '-' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('User') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $log->createdBy?->name ?? __('System') }}</p>
                </div>
            </div>
        </div>

        <div class="panel p-6">
            <p class="panel-heading">{{ __('Context') }}</p>
            <pre class="mt-3 whitespace-pre-wrap rounded-xl border border-border/70 bg-surface-2/70 p-4 text-sm text-muted">{{ $log->context ? json_encode($log->context, JSON_PRETTY_PRINT) : 'No context provided.' }}</pre>
        </div>
    </div>
</x-admin-layout>
