﻿<x-admin-layout :title="__('System Configuration')" :subtitle="__('Tune global settings, policies, and platform integrations.')">
    <div class="space-y-6">
        <div class="panel p-6" data-tab-group data-tab-storage="system-settings-tab">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Settings Hub') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Switch tabs to manage core system preferences.') }}</p>
                </div>
            </div>

            <div class="mt-5 flex flex-wrap gap-2">
                <button type="button" class="btn-secondary" data-tab-button="general">{{ __('General') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="site">{{ __('Site Info') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="smtp">{{ __('SMTP') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="footer">{{ __('Footer') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="seo">{{ __('SEO') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="media">{{ __('Media') }}</button>
                @if(app(\App\Services\PlanLimitService::class)->hasFeature(auth()->user(), 'has_cloud_storage'))
                <button type="button" class="btn-secondary" data-tab-button="cloud_storage">{{ __('Cloud') }}</button>
                @endif
                <button type="button" class="btn-secondary" data-tab-button="social">{{ __('Social Login') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="gdpr">{{ __('GDPR') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="maintenance">{{ __('Maintenance') }}</button>
                <button type="button" class="btn-secondary" data-tab-button="pwa">{{ __('PWA') }}</button>
            </div>

            <div class="mt-6 space-y-8">
                <div data-tab-panel="general">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'general') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="grid gap-6 lg:grid-cols-2">
                            <div class="panel p-6">
                                <p class="panel-heading">{{ __('Localization') }}</p>
                                <div class="mt-4 grid gap-4">
                                    <div>
                                        <x-input-label for="default_language" :value="__('Default Language')" />
                                        <select id="default_language" name="default_language" class="input-field mt-1">
                                            <option value="">{{ __('Select language') }}</option>
                                            @foreach ($languages as $language)
                                                <option value="{{ $language->code }}" @selected((string) old('default_language', $settings['general']['default_language']) === (string) $language->code)>
                                                    {{ $language->name }} ({{ $language->code }})
                                                </option>
                                            @endforeach
                                        </select>
                                        <x-input-error :messages="$errors->get('default_language')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label for="default_currency" :value="__('Default Currency')" />
                                        <select id="default_currency" name="default_currency" class="input-field mt-1">
                                            <option value="">{{ __('Select currency') }}</option>
                                            @foreach ($currencies as $currency)
                                                <option value="{{ $currency->code }}" @selected((string) old('default_currency', $settings['general']['default_currency']) === (string) $currency->code)>
                                                    {{ $currency->name }} ({{ $currency->code }})
                                                </option>
                                            @endforeach
                                        </select>
                                        <x-input-error :messages="$errors->get('default_currency')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label for="default_timezone" :value="__('Default Timezone')" />
                                        <x-text-input id="default_timezone" name="default_timezone" type="text" class="mt-1" :value="old('default_timezone', $settings['general']['default_timezone'])" placeholder="{{ __('Asia/Kolkata') }}" />
                                        <x-input-error :messages="$errors->get('default_timezone')" class="mt-2" />
                                    </div>
                                </div>
                            </div>

                            <div class="panel p-6">
                                <p class="panel-heading">{{ __('Formatting') }}</p>
                                <div class="mt-4 grid gap-4">
                                    <div>
                                        <x-input-label for="date_format" :value="__('Date Format')" />
                                        <x-text-input id="date_format" name="date_format" type="text" class="mt-1" :value="old('date_format', $settings['general']['date_format'])" placeholder="d M Y" />
                                        <x-input-error :messages="$errors->get('date_format')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label for="time_format" :value="__('Time Format')" />
                                        <x-text-input id="time_format" name="time_format" type="text" class="mt-1" :value="old('time_format', $settings['general']['time_format'])" placeholder="H:i" />
                                        <x-input-error :messages="$errors->get('time_format')" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Support Contact') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="support_email" :value="__('Support Email')" />
                                    <x-text-input id="support_email" name="support_email" type="email" maxlength="30" class="mt-1" :value="old('support_email', $settings['general']['support_email'])" placeholder="{{ __('support@example.com') }}" />
                                    <x-input-error :messages="$errors->get('support_email')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="support_phone" :value="__('Support Phone')" />
                                    <x-text-input id="support_phone" name="support_phone" type="text" inputmode="tel" pattern="\+?[0-9]{1,15}" maxlength="15" data-phone-input class="mt-1" :value="old('support_phone', $settings['general']['support_phone'])" placeholder="{{ __('+91XXXXXXXXXX') }}" />
                                    <x-input-error :messages="$errors->get('support_phone')" class="mt-2" />
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label :value="__('Multi Language Support')" />
                                    <input type="hidden" name="enable_multi_language" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="enable_multi_language" value="1" class="peer sr-only" @checked((bool) old('enable_multi_language', $settings['general']['enable_multi_language']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('enable_multi_language', $settings['general']['enable_multi_language']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save General Settings') }}</button>
                        </div>
                    </form>
                </div>
                <div data-tab-panel="site">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'site') }}" enctype="multipart/form-data" class="space-y-6" data-location-scope>
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Brand Assets') }}</p>
                            <div class="mt-4 grid gap-6 lg:grid-cols-2">
                                <div class="flex items-center gap-4">
                                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                        <img src="{{ $settings['site']['site_logo'] ? asset('storage/' . $settings['site']['site_logo']) : asset('images/placeholder-media.svg') }}" alt="Site logo" class="h-full w-full object-cover">
                                    </div>
                                    <div>
                                        <x-input-label for="site_logo" :value="__('Site Logo')" />
                                        <input id="site_logo" name="site_logo" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                                        <x-input-error :messages="$errors->get('site_logo')" class="mt-2" />
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                        <img src="{{ $settings['site']['admin_logo'] ? asset('storage/' . $settings['site']['admin_logo']) : asset('images/placeholder-media.svg') }}" alt="Admin logo" class="h-full w-full object-cover">
                                    </div>
                                    <div>
                                        <x-input-label for="admin_logo" :value="__('Admin Logo')" />
                                        <input id="admin_logo" name="admin_logo" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                                        <x-input-error :messages="$errors->get('admin_logo')" class="mt-2" />
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                        <img src="{{ $settings['site']['favicon'] ? asset('storage/' . $settings['site']['favicon']) : asset('images/placeholder-media.svg') }}" alt="Favicon" class="h-full w-full object-cover">
                                    </div>
                                    <div>
                                        <x-input-label for="favicon" :value="__('Favicon')" />
                                        <input id="favicon" name="favicon" type="file" accept=".jpg,.jpeg,.png,.webp,.ico" class="mt-2 text-sm text-muted">
                                        <x-input-error :messages="$errors->get('favicon')" class="mt-2" />
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                        <img src="{{ $settings['footer']['footer_logo'] ? asset('storage/' . $settings['footer']['footer_logo']) : asset('images/placeholder-media.svg') }}" alt="Footer logo" class="h-full w-full object-cover">
                                    </div>
                                    <div>
                                        <x-input-label :value="__('Footer Logo')" />
                                        <p class="mt-2 text-xs text-muted">{{ __('Footer logo is managed in the Footer tab.') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Company Information') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="site_name" :value="__('Site Name')" />
                                    <x-text-input id="site_name" name="site_name" type="text" class="mt-1" :value="old('site_name', $settings['site']['site_name'])" />
                                    <x-input-error :messages="$errors->get('site_name')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="company_name" :value="__('Company Name')" />
                                    <x-text-input id="company_name" name="company_name" type="text" class="mt-1" :value="old('company_name', $settings['site']['company_name'])" />
                                    <x-input-error :messages="$errors->get('company_name')" class="mt-2" />
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label for="company_address" :value="__('Company Address')" />
                                    <x-text-input id="company_address" name="company_address" type="text" class="mt-1" :value="old('company_address', $settings['site']['company_address'])" />
                                    <x-input-error :messages="$errors->get('company_address')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="company_country_id" :value="__('Company Country')" />
                                    <select id="company_country_id" name="company_country_id" class="input-field mt-1" data-country-select>
                                        <option value="">{{ __('Select country') }}</option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}" @selected((string) old('company_country_id', $settings['site']['company_country_id']) === (string) $country->id)>{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('company_country_id')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="company_state_id" :value="__('Company State')" />
                                    <select id="company_state_id" name="company_state_id" class="input-field mt-1" data-state-select>
                                        <option value="">{{ __('Select state') }}</option>
                                        @foreach ($states as $state)
                                            <option value="{{ $state->id }}" data-country-id="{{ $state->country_id }}" @selected((string) old('company_state_id', $settings['site']['company_state_id']) === (string) $state->id)>{{ $state->name }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('company_state_id')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="company_city_id" :value="__('Company City')" />
                                    <select id="company_city_id" name="company_city_id" class="input-field mt-1" data-city-select>
                                        <option value="">{{ __('Select city') }}</option>
                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}" data-state-id="{{ $city->state_id }}" @selected((string) old('company_city_id', $settings['site']['company_city_id']) === (string) $city->id)>{{ $city->name }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('company_city_id')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="company_phone" :value="__('Company Phone')" />
                                    <x-text-input id="company_phone" name="company_phone" type="text" inputmode="tel" pattern="\+?[0-9]{1,15}" maxlength="15" data-phone-input class="mt-1" :value="old('company_phone', $settings['site']['company_phone'])" />
                                    <x-input-error :messages="$errors->get('company_phone')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="business_hours" :value="__('Business Hours')" />
                                    <x-text-input id="business_hours" name="business_hours" type="text" class="mt-1" :value="old('business_hours', $settings['site']['business_hours'])" placeholder="{{ __('Mon-Sat 9am-7pm') }}" />
                                    <x-input-error :messages="$errors->get('business_hours')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="latitude" :value="__('Latitude')" />
                                    <x-text-input id="latitude" name="latitude" type="text" class="mt-1" :value="old('latitude', $settings['site']['latitude'])" />
                                    <x-input-error :messages="$errors->get('latitude')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="longitude" :value="__('Longitude')" />
                                    <x-text-input id="longitude" name="longitude" type="text" class="mt-1" :value="old('longitude', $settings['site']['longitude'])" />
                                    <x-input-error :messages="$errors->get('longitude')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Browser Rules') }}</p>
                            <div class="mt-4 flex flex-wrap gap-6">
                                <div>
                                    <x-input-label :value="__('Disable Right Click')" />
                                    <input type="hidden" name="right_click_disable" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="right_click_disable" value="1" class="peer sr-only" @checked((bool) old('right_click_disable', $settings['site']['right_click_disable']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('right_click_disable', $settings['site']['right_click_disable']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label :value="__('Block UC Browser')" />
                                    <input type="hidden" name="uc_browser_block" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="uc_browser_block" value="1" class="peer sr-only" @checked((bool) old('uc_browser_block', $settings['site']['uc_browser_block']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('uc_browser_block', $settings['site']['uc_browser_block']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Site Information') }}</button>
                        </div>
                    </form>
                </div>
                <div data-tab-panel="smtp">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'smtp') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="grid gap-6 lg:grid-cols-2">
                            <div class="panel p-6">
                                <p class="panel-heading">{{ __('Server Credentials') }}</p>
                                <div class="mt-4 grid gap-4">
                                    <div>
                                        <x-input-label for="smtp_host" :value="__('SMTP Host')" />
                                        <x-text-input id="smtp_host" name="smtp_host" type="text" class="mt-1" :value="old('smtp_host', $settings['smtp']['smtp_host'])" />
                                        <x-input-error :messages="$errors->get('smtp_host')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label for="smtp_port" :value="__('SMTP Port')" />
                                        <x-text-input id="smtp_port" name="smtp_port" type="number" class="mt-1" :value="old('smtp_port', $settings['smtp']['smtp_port'])" />
                                        <x-input-error :messages="$errors->get('smtp_port')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label for="smtp_username" :value="__('SMTP Username')" />
                                        <x-text-input id="smtp_username" name="smtp_username" type="text" class="mt-1" :value="old('smtp_username', $settings['smtp']['smtp_username'])" />
                                        <x-input-error :messages="$errors->get('smtp_username')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label :value="__('SMTP Password')" />
                                        <div class="relative mt-1">
                                            <x-text-input id="smtp_password" name="smtp_password" type="password" class="pr-12" :value="old('smtp_password', $settings['smtp']['smtp_password'])" />
                                            <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="smtp_password" aria-label="Toggle password visibility">
                                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                                                    <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                                                    <circle cx="12" cy="12" r="3"></circle>
                                                </svg>
                                                <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                                                    <path d="M3 5l16 16"></path>
                                                    <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                                                    <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                                                    <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                                                </svg>
                                            </button>
                                        </div>
                                        <x-input-error :messages="$errors->get('smtp_password')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label for="smtp_encryption" :value="__('Encryption')" />
                                        <select id="smtp_encryption" name="smtp_encryption" class="input-field mt-1">
                                            @foreach (['tls' => 'TLS', 'ssl' => 'SSL', 'none' => 'None'] as $value => $label)
                                                <option value="{{ $value }}" @selected(old('smtp_encryption', $settings['smtp']['smtp_encryption']) === $value)>{{ $label }}</option>
                                            @endforeach
                                        </select>
                                        <x-input-error :messages="$errors->get('smtp_encryption')" class="mt-2" />
                                    </div>
                                </div>
                            </div>

                            <div class="panel p-6">
                                <p class="panel-heading">{{ __('Sender Identity') }}</p>
                                <div class="mt-4 grid gap-4">
                                    <div>
                                        <x-input-label for="smtp_from_address" :value="__('From Address')" />
                                    <x-text-input id="smtp_from_address" name="smtp_from_address" type="email" maxlength="30" class="mt-1" :value="old('smtp_from_address', $settings['smtp']['smtp_from_address'])" />
                                        <x-input-error :messages="$errors->get('smtp_from_address')" class="mt-2" />
                                    </div>
                                    <div>
                                        <x-input-label for="smtp_from_name" :value="__('From Name')" />
                                        <x-text-input id="smtp_from_name" name="smtp_from_name" type="text" class="mt-1" :value="old('smtp_from_name', $settings['smtp']['smtp_from_name'])" />
                                        <x-input-error :messages="$errors->get('smtp_from_name')" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Send Test Email') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-[1fr,auto]">
                                <div>
                                    <x-input-label for="test_email" :value="__('Test Recipient Email')" />
                                    <x-text-input id="test_email" name="test_email" type="email" maxlength="30" class="mt-1" form="smtp-test-form" placeholder="{{ __('you@example.com') }}" />
                                </div>
                                <div class="flex items-end">
                                    <button type="submit" form="smtp-test-form" class="btn-secondary">{{ __('Send Test') }}</button>
                                </div>
                            </div>
                            <p class="mt-3 text-xs text-muted">{{ __('Use this after saving SMTP settings to confirm delivery.') }}</p>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save SMTP Settings') }}</button>
                        </div>
                    </form>

                    <form id="smtp-test-form" method="POST" action="{{ route('admin.system-settings.smtp.test') }}" class="hidden">
                        @csrf
                    </form>
                </div>
                <div data-tab-panel="footer">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'footer') }}" enctype="multipart/form-data" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Footer Branding') }}</p>
                            <div class="mt-4 flex items-center gap-4">
                                <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                    <img src="{{ $settings['footer']['footer_logo'] ? asset('storage/' . $settings['footer']['footer_logo']) : asset('images/placeholder-media.svg') }}" alt="Footer logo" class="h-full w-full object-cover">
                                </div>
                                <div>
                                    <x-input-label for="footer_logo" :value="__('Footer Logo')" />
                                    <input id="footer_logo" name="footer_logo" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                                    <x-input-error :messages="$errors->get('footer_logo')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Social Share Links') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                @foreach (['facebook' => 'Facebook', 'x' => 'X', 'linkedin' => 'LinkedIn', 'instagram' => 'Instagram', 'whatsapp' => 'WhatsApp'] as $key => $label)
                                    <div>
                                        <x-input-label for="footer_social_{{ $key }}" :value="__($label)" />
                                        <x-text-input id="footer_social_{{ $key }}" name="footer_social[{{ $key }}]" type="url" class="mt-1" :value="old('footer_social.' . $key, $settings['footer']['footer_social'][$key])" />
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('App Download Links') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-3">
                                @foreach (['android' => 'Android', 'ios' => 'iOS', 'direct' => 'Direct Link'] as $key => $label)
                                    <div>
                                        <x-input-label for="app_links_{{ $key }}" :value="__($label)" />
                                        <x-text-input id="app_links_{{ $key }}" name="app_links[{{ $key }}]" type="url" class="mt-1" :value="old('app_links.' . $key, $settings['footer']['app_links'][$key])" />
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Footer Settings') }}</button>
                        </div>
                    </form>
                </div>
                <div data-tab-panel="seo">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'seo') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Meta Configuration') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="meta_title" :value="__('Meta Title')" />
                                    <x-text-input id="meta_title" name="meta_title" type="text" class="mt-1" :value="old('meta_title', $settings['seo']['meta_title'])" />
                                    <x-input-error :messages="$errors->get('meta_title')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="meta_keywords" :value="__('Meta Keywords')" />
                                    <x-text-input id="meta_keywords" name="meta_keywords" type="text" class="mt-1" :value="old('meta_keywords', $settings['seo']['meta_keywords'])" />
                                    <x-input-error :messages="$errors->get('meta_keywords')" class="mt-2" />
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label for="meta_description" :value="__('Meta Description')" />
                                    <textarea id="meta_description" name="meta_description" rows="4" class="input-field mt-1" data-no-wysiwyg>{{ old('meta_description', $settings['seo']['meta_description']) }}</textarea>
                                    <x-input-error :messages="$errors->get('meta_description')" class="mt-2" />
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label :value="__('Sitemap Generator')" />
                                    <input type="hidden" name="sitemap_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="sitemap_enabled" value="1" class="peer sr-only" @checked((bool) old('sitemap_enabled', $settings['seo']['sitemap_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('sitemap_enabled', $settings['seo']['sitemap_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Crawler Files') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="robots_txt" :value="__('robots.txt')" />
                                    <textarea id="robots_txt" name="robots_txt" rows="6" class="input-field mt-1" data-no-wysiwyg>{{ old('robots_txt', $settings['seo']['robots_txt']) }}</textarea>
                                    <x-input-error :messages="$errors->get('robots_txt')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="llm_txt" :value="__('llm.txt')" />
                                    <textarea id="llm_txt" name="llm_txt" rows="6" class="input-field mt-1" data-no-wysiwyg>{{ old('llm_txt', $settings['seo']['llm_txt']) }}</textarea>
                                    <x-input-error :messages="$errors->get('llm_txt')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save SEO Settings') }}</button>
                        </div>
                    </form>
                </div>
                <div data-tab-panel="media">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'media') }}" enctype="multipart/form-data" class="space-y-6">
                        @csrf
                        @method('POST')

                        @php
                            $mediaSettings = $settings['media'] ?? [];
                            $maxFileMb = isset($mediaSettings['max_file_size']) ? round($mediaSettings['max_file_size'] / 1024, 1) : '';
                            $chunkMb = isset($mediaSettings['chunk_size']) ? round($mediaSettings['chunk_size'] / 1024 / 1024, 1) : '';
                            $storageLimit = $mediaSettings['storage_limit_gb'] ?? '';
                            $watermarkEnabled = (bool) ($mediaSettings['watermark']['enabled'] ?? false);
                            $watermarkImage = $mediaSettings['watermark']['image'] ?? null;
                            $watermarkPosition = old('watermark_position', $mediaSettings['watermark']['position'] ?? 'top_right');
                            $watermarkPositions = config('events.media.watermark.positions', []);
                        @endphp

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Upload Limits') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-3">
                                <div>
                                    <x-input-label for="media_max_file_size" :value="__('Max Upload Size (MB)')" />
                                    <x-text-input id="media_max_file_size" name="media_max_file_size" type="number" step="0.1" class="mt-1" :value="old('media_max_file_size', $maxFileMb)" />
                                    <x-input-error :messages="$errors->get('media_max_file_size')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="chunk_size" :value="__('Chunk Size (MB)')" />
                                    <x-text-input id="chunk_size" name="chunk_size" type="number" step="0.1" class="mt-1" :value="old('chunk_size', $chunkMb)" />
                                    <x-input-error :messages="$errors->get('chunk_size')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="storage_limit_gb" :value="__('Storage Limit (GB)')" />
                                    <x-text-input id="storage_limit_gb" name="storage_limit_gb" type="number" step="0.1" class="mt-1" :value="old('storage_limit_gb', $storageLimit)" />
                                    <x-input-error :messages="$errors->get('storage_limit_gb')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Image Optimization') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="max_width" :value="__('Max Width (px)')" />
                                    <x-text-input id="max_width" name="max_width" type="number" class="mt-1" :value="old('max_width', $mediaSettings['max_width'] ?? '')" />
                                    <x-input-error :messages="$errors->get('max_width')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="quality" :value="__('Quality (1-100)')" />
                                    <x-text-input id="quality" name="quality" type="number" class="mt-1" :value="old('quality', $mediaSettings['quality'] ?? '')" />
                                    <x-input-error :messages="$errors->get('quality')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Watermark Protection') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-3">
                                <div>
                                    <x-input-label :value="__('Enable Watermark')" />
                                    <input type="hidden" name="watermark_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="watermark_enabled" value="1" class="peer sr-only" @checked((bool) old('watermark_enabled', $watermarkEnabled))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('watermark_enabled', $watermarkEnabled) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div class="flex items-center gap-4">
                                    @if ($watermarkImage && Storage::disk('public')->exists($watermarkImage))
                                        <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                            <img src="{{ asset('storage/' . $watermarkImage) }}" alt="Watermark" class="h-full w-full object-contain">
                                        </div>
                                    @endif
                                    <div>
                                        <x-input-label for="watermark_image" :value="__('Watermark Image')" />
                                        <input id="watermark_image" name="watermark_image" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                                        <x-input-error :messages="$errors->get('watermark_image')" class="mt-2" />
                                        <p class="mt-2 text-xs text-muted">PNG with transparency works best.{{ $watermarkImage ? '' : ' No watermark image uploaded yet.' }}</p>
                                    </div>
                                </div>
                                <div>
                                    <x-input-label for="watermark_position" :value="__('Watermark Position')" />
                                    <select id="watermark_position" name="watermark_position" class="input-field mt-1">
                                        @foreach ($watermarkPositions as $value => $label)
                                            <option value="{{ $value }}" @selected((string) $watermarkPosition === (string) $value)>{{ $label }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('watermark_position')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('FTP Tethering') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="ftp_path" :value="__('FTP Watch Path')" />
                                    <x-text-input id="ftp_path" name="ftp_path" type="text" class="mt-1" :value="old('ftp_path', $mediaSettings['ftp_path'] ?? '')" />
                                    <x-input-error :messages="$errors->get('ftp_path')" class="mt-2" />
                                </div>
                                <div class="text-xs text-muted lg:self-end">
                                    Files placed in <span class="font-semibold text-ink">{{ __('/EVENT_ID') }}</span> folders will be ingested during FTP sync.
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Media Settings') }}</button>
                        </div>
                    </form>
                </div>
                @if(app(\App\Services\PlanLimitService::class)->hasFeature(auth()->user(), 'has_cloud_storage'))
                <div data-tab-panel="cloud_storage">
                    <form id="cloud-storage-test-form" method="POST" action="{{ route('admin.system-settings.cloud-storage.test') }}">
                        @csrf
                    </form>
                    <form id="cloud-storage-migrate-form" method="POST" action="{{ route('admin.system-settings.cloud-storage.migrate') }}">
                        @csrf
                    </form>
                    <form method="POST" action="{{ route('admin.system-settings.update', 'cloud_storage') }}" class="space-y-6" data-cloud-storage-form>
                        @csrf
                        @method('POST')

                        @php
                            $cloud = $settings['cloud_storage'] ?? [];
                            $cloudProviders = $cloud['providers'] ?? [];
                            $selectedProvider = old('provider', $cloud['provider'] ?? 's3');
                            $cloudEnabled = (bool) old('enabled', $cloud['enabled'] ?? false);
                            $cloudVisibility = old('visibility', $cloud['visibility'] ?? 'private');
                            $cloudBasePath = old('base_path', $cloud['base_path'] ?? '');
                            $cloudLimits = $cloud['limits'] ?? [];
                            $limitEnabled = (bool) old('limit_enabled', $cloudLimits['enabled'] ?? false);
                            $limitValue = old('limit_value', $cloudLimits['value'] ?? '');
                            $limitUnit = old('limit_unit', $cloudLimits['unit'] ?? 'gb');
                            $lastTestStatus = $cloud['last_test_status'] ?? 'disabled';
                            $lastTestMessage = $cloud['last_test_message'] ?? '';
                            $lastTestAt = $cloud['last_test_at'] ?? null;
                            $migration = $cloud['migration'] ?? [];
                        @endphp

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Connection Status') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-3">
                                <div>
                                    <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Provider') }}</p>
                                    <p class="mt-2 text-sm font-semibold text-ink">{{ app(\App\Services\CloudStorageManager::class)->providerLabel() }}</p>
                                </div>
                                <div>
                                    <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Status') }}</p>
                                    <p class="mt-2 text-sm font-semibold text-ink">
                                        {{ $lastTestStatus === 'connected' ? 'Connected' : ($lastTestStatus === 'error' ? __('Error') : __('Disabled')) }}
                                    </p>
                                    @if ($lastTestMessage)
                                        <p class="mt-1 text-xs text-muted">{{ $lastTestMessage }}</p>
                                    @endif
                                </div>
                                <div>
                                    <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Last Test') }}</p>
                                    <p class="mt-2 text-sm font-semibold text-ink">{{ $lastTestAt ? \Illuminate\Support\Carbon::parse($lastTestAt)->format('d M Y, H:i') : 'Not tested' }}</p>
                                    <p class="mt-1 text-xs text-muted">Usage {{ $storageSummary['used_label'] }} of {{ $storageSummary['limit_label'] }}</p>
                                </div>
                            </div>
                            <div class="mt-4 flex flex-wrap items-center gap-3">
                                <button type="submit" class="btn-secondary" form="cloud-storage-test-form">{{ __('Test Connection') }}</button>
                                <button type="submit" class="btn-secondary" form="cloud-storage-migrate-form">{{ __('Migrate Existing Media') }}</button>
                                @if (($migration['status'] ?? null) === 'running')
                                    <span class="text-xs text-muted">
                                        Migration running: {{ $migration['processed'] ?? 0 }} of {{ $migration['total'] ?? 0 }} processed.
                                    </span>
                                @elseif (($migration['status'] ?? null) === 'completed')
                                    <span class="text-xs text-muted">{{ __('Migration completed.') }}</span>
                                @elseif (($migration['status'] ?? null) === 'failed')
                                    <span class="text-xs text-danger">{{ __('Migration failed:') }} {{ $migration['last_error'] ?? __('Unknown error') }}</span>
                                @endif
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Cloud Storage Preferences') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-3">
                                <div>
                                    <x-input-label :value="__('Enable Client Storage')" />
                                    <input type="hidden" name="enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="enabled" value="1" class="peer sr-only" @checked($cloudEnabled)>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ $cloudEnabled ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label for="provider" :value="__('Provider')" />
                                    <select id="provider" name="provider" class="input-field mt-1" data-cloud-storage-provider>
                                        <option value="s3" @selected($selectedProvider === 's3')>AWS S3</option>
                                        <option value="gcs" @selected($selectedProvider === 'gcs')>{{ __('Google Cloud Storage') }}</option>
                                        <option value="gdrive" @selected($selectedProvider === 'gdrive')>{{ __('Google Drive') }}</option>
                                        <option value="azure" @selected($selectedProvider === 'azure')>{{ __('Azure Blob Storage') }}</option>
                                        <option value="bunny" @selected($selectedProvider === 'bunny')>{{ __('Bunny.net Storage') }}</option>
                                        <option value="wasabi" @selected($selectedProvider === 'wasabi')>{{ __('Wasabi Storage') }}</option>
                                    </select>
                                </div>
                                <div>
                                    <x-input-label for="visibility" :value="__('Visibility')" />
                                    <select id="visibility" name="visibility" class="input-field mt-1">
                                        <option value="private" @selected($cloudVisibility === 'private')>{{ __('Private (signed access)') }}</option>
                                        <option value="public" @selected($cloudVisibility === 'public')>{{ __('Public') }}</option>
                                    </select>
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label for="base_path" :value="__('Base Path Prefix (optional)')" />
                                    <x-text-input id="base_path" name="base_path" type="text" class="mt-1" :value="$cloudBasePath" placeholder="{{ __('clients/your-client-id') }}" />
                                    <p class="mt-1 text-xs text-muted">{{ __('Media will be stored under this prefix (e.g. clients/acme/events/123).') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Storage Usage Limits') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-3">
                                <div>
                                    <x-input-label :value="__('Enable Limit')" />
                                    <input type="hidden" name="limit_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="limit_enabled" value="1" class="peer sr-only" @checked($limitEnabled)>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ $limitEnabled ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label for="limit_value" :value="__('Limit Amount')" />
                                    <x-text-input id="limit_value" name="limit_value" type="number" step="0.1" class="mt-1" :value="$limitValue" />
                                </div>
                                <div>
                                    <x-input-label for="limit_unit" :value="__('Limit Unit')" />
                                    <select id="limit_unit" name="limit_unit" class="input-field mt-1">
                                        <option value="gb" @selected($limitUnit === 'gb')>{{ __('GB') }}</option>
                                        <option value="tb" @selected($limitUnit === 'tb')>{{ __('TB') }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6" data-provider-panel="s3">
                            <p class="panel-heading">{{ __('AWS S3 Credentials') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Access Key ID')" />
                                    <x-text-input name="providers[s3][key]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['s3']['key']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Secret Access Key')" />
                                    <x-text-input name="providers[s3][secret]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['s3']['secret']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Region')" />
                                    <x-text-input name="providers[s3][region]" type="text" class="mt-1" :value="old('providers.s3.region', $cloudProviders['s3']['region'] ?? '')" placeholder="{{ __('ap-south-1') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Bucket')" />
                                    <x-text-input name="providers[s3][bucket]" type="text" class="mt-1" :value="old('providers.s3.bucket', $cloudProviders['s3']['bucket'] ?? '')" placeholder="{{ __('client-bucket-name') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Endpoint (optional)')" />
                                    <x-text-input name="providers[s3][endpoint]" type="text" class="mt-1" :value="old('providers.s3.endpoint', $cloudProviders['s3']['endpoint'] ?? '')" placeholder="{{ __('https://s3.amazonaws.com') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Public URL (optional)')" />
                                    <x-text-input name="providers[s3][url]" type="text" class="mt-1" :value="old('providers.s3.url', $cloudProviders['s3']['url'] ?? '')" placeholder="{{ __('https://cdn.example.com') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('CDN URL (optional)')" />
                                    <x-text-input name="providers[s3][cdn_url]" type="text" class="mt-1" :value="old('providers.s3.cdn_url', $cloudProviders['s3']['cdn_url'] ?? '')" placeholder="{{ __('https://d1234567890.cloudfront.net') }}" />
                                    <p class="mt-1 text-xs text-muted">{{ __('CloudFront or other CDN distribution URL. If set, media URLs will use this instead of presigned S3 URLs.') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6" data-provider-panel="gcs">
                            <p class="panel-heading">{{ __('Google Cloud Storage') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Project ID')" />
                                    <x-text-input name="providers[gcs][project_id]" type="text" class="mt-1" :value="old('providers.gcs.project_id', $cloudProviders['gcs']['project_id'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Bucket')" />
                                    <x-text-input name="providers[gcs][bucket]" type="text" class="mt-1" :value="old('providers.gcs.bucket', $cloudProviders['gcs']['bucket'] ?? '')" />
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label :value="__('Service Account JSON')" />
                                    <textarea name="providers[gcs][key_file]" rows="6" class="input-field mt-1" placeholder="{{ __('Paste the JSON key here (leave blank to keep current).') }}"></textarea>
                                    @if (! empty($cloudProviders['gcs']['key_file']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label :value="__('CDN URL (optional)')" />
                                    <x-text-input name="providers[gcs][cdn_url]" type="text" class="mt-1" :value="old('providers.gcs.cdn_url', $cloudProviders['gcs']['cdn_url'] ?? '')" placeholder="{{ __('https://cdn.example.com') }}" />
                                    <p class="mt-1 text-xs text-muted">{{ __('If set, media URLs will use this CDN instead of presigned GCS URLs.') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6" data-provider-panel="gdrive">
                            <p class="panel-heading">{{ __('Google Drive') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Client ID')" />
                                    <x-text-input name="providers[gdrive][client_id]" type="text" class="mt-1" :value="old('providers.gdrive.client_id', $cloudProviders['gdrive']['client_id'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Client Secret')" />
                                    <x-text-input name="providers[gdrive][client_secret]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['gdrive']['client_secret']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Refresh Token')" />
                                    <x-text-input name="providers[gdrive][refresh_token]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['gdrive']['refresh_token']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Root Folder (optional)')" />
                                    <x-text-input name="providers[gdrive][folder]" type="text" class="mt-1" :value="old('providers.gdrive.folder', $cloudProviders['gdrive']['folder'] ?? '')" placeholder="{{ __('My_App_Root') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Team Drive ID (optional)')" />
                                    <x-text-input name="providers[gdrive][team_drive_id]" type="text" class="mt-1" :value="old('providers.gdrive.team_drive_id', $cloudProviders['gdrive']['team_drive_id'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Shared Folder ID (optional)')" />
                                    <x-text-input name="providers[gdrive][shared_folder_id]" type="text" class="mt-1" :value="old('providers.gdrive.shared_folder_id', $cloudProviders['gdrive']['shared_folder_id'] ?? '')" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6" data-provider-panel="azure">
                            <p class="panel-heading">{{ __('Azure Blob Storage') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Account Name')" />
                                    <x-text-input name="providers[azure][account_name]" type="text" class="mt-1" :value="old('providers.azure.account_name', $cloudProviders['azure']['account_name'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Account Key')" />
                                    <x-text-input name="providers[azure][account_key]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['azure']['account_key']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Container')" />
                                    <x-text-input name="providers[azure][container]" type="text" class="mt-1" :value="old('providers.azure.container', $cloudProviders['azure']['container'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Endpoint (optional)')" />
                                    <x-text-input name="providers[azure][endpoint]" type="text" class="mt-1" :value="old('providers.azure.endpoint', $cloudProviders['azure']['endpoint'] ?? '')" placeholder="{{ __('https://account.blob.core.windows.net') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Public URL (optional)')" />
                                    <x-text-input name="providers[azure][url]" type="text" class="mt-1" :value="old('providers.azure.url', $cloudProviders['azure']['url'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('CDN URL (optional)')" />
                                    <x-text-input name="providers[azure][cdn_url]" type="text" class="mt-1" :value="old('providers.azure.cdn_url', $cloudProviders['azure']['cdn_url'] ?? '')" placeholder="{{ __('https://mycdn.azureedge.net') }}" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6" data-provider-panel="bunny">
                            <p class="panel-heading">{{ __('Bunny.net Storage') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Storage Zone')" />
                                    <x-text-input name="providers[bunny][storage_zone]" type="text" class="mt-1" :value="old('providers.bunny.storage_zone', $cloudProviders['bunny']['storage_zone'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Access Key')" />
                                    <x-text-input name="providers[bunny][access_key]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['bunny']['access_key']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Region')" />
                                    <x-text-input name="providers[bunny][region]" type="text" class="mt-1" :value="old('providers.bunny.region', $cloudProviders['bunny']['region'] ?? '')" placeholder="{{ __('ny, la, sg') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('S3 Endpoint')" />
                                    <x-text-input name="providers[bunny][endpoint]" type="text" class="mt-1" :value="old('providers.bunny.endpoint', $cloudProviders['bunny']['endpoint'] ?? '')" placeholder="{{ __('https://storage.bunnycdn.com') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Public URL (optional)')" />
                                    <x-text-input name="providers[bunny][url]" type="text" class="mt-1" :value="old('providers.bunny.url', $cloudProviders['bunny']['url'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('CDN URL (optional)')" />
                                    <x-text-input name="providers[bunny][cdn_url]" type="text" class="mt-1" :value="old('providers.bunny.cdn_url', $cloudProviders['bunny']['cdn_url'] ?? '')" placeholder="{{ __('https://myzone.b-cdn.net') }}" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6" data-provider-panel="wasabi">
                            <p class="panel-heading">{{ __('Wasabi Storage') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label :value="__('Access Key ID')" />
                                    <x-text-input name="providers[wasabi][key]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['wasabi']['key']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Secret Access Key')" />
                                    <x-text-input name="providers[wasabi][secret]" type="password" class="mt-1" autocomplete="new-password" placeholder="{{ __('Leave blank to keep current') }}" />
                                    @if (! empty($cloudProviders['wasabi']['secret']))
                                        <p class="mt-1 text-xs text-muted">{{ __('Saved (hidden).') }}</p>
                                    @endif
                                </div>
                                <div>
                                    <x-input-label :value="__('Region')" />
                                    <x-text-input name="providers[wasabi][region]" type="text" class="mt-1" :value="old('providers.wasabi.region', $cloudProviders['wasabi']['region'] ?? '')" placeholder="{{ __('ap-south-1') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Bucket')" />
                                    <x-text-input name="providers[wasabi][bucket]" type="text" class="mt-1" :value="old('providers.wasabi.bucket', $cloudProviders['wasabi']['bucket'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Endpoint (optional)')" />
                                    <x-text-input name="providers[wasabi][endpoint]" type="text" class="mt-1" :value="old('providers.wasabi.endpoint', $cloudProviders['wasabi']['endpoint'] ?? '')" placeholder="{{ __('https://s3.ap-south-1.wasabisys.com') }}" />
                                </div>
                                <div>
                                    <x-input-label :value="__('Public URL (optional)')" />
                                    <x-text-input name="providers[wasabi][url]" type="text" class="mt-1" :value="old('providers.wasabi.url', $cloudProviders['wasabi']['url'] ?? '')" />
                                </div>
                                <div>
                                    <x-input-label :value="__('CDN URL (optional)')" />
                                    <x-text-input name="providers[wasabi][cdn_url]" type="text" class="mt-1" :value="old('providers.wasabi.cdn_url', $cloudProviders['wasabi']['cdn_url'] ?? '')" placeholder="{{ __('https://cdn.example.com') }}" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Cloud Storage') }}</button>
                        </div>
                    </form>
                </div>
                @endif
                <div data-tab-panel="social">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'social') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="grid gap-6 lg:grid-cols-2">
                            @foreach ($socialProviders as $key => $label)
                                @php
                                    $provider = $settings['social']['providers'][$key] ?? ['enabled' => false, 'client_id' => '', 'client_secret' => '', 'redirect_url' => ''];
                                    $secretId = $key . '_client_secret';
                                @endphp
                                <div class="panel p-6">
                                    <div class="flex items-center justify-between">
                                        <p class="panel-heading">{{ $label }}</p>
                                        <div>
                                            <input type="hidden" name="providers[{{ $key }}][enabled]" value="0">
                                            <label class="inline-flex items-center gap-3 text-sm text-muted">
                                                <input type="checkbox" name="providers[{{ $key }}][enabled]" value="1" class="peer sr-only" @checked((bool) old('providers.' . $key . '.enabled', $provider['enabled']))>
                                                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mt-4 grid gap-4">
                                        <div>
                                            <x-input-label :value="__('Client ID')" />
                                            <x-text-input name="providers[{{ $key }}][client_id]" type="text" class="mt-1" :value="old('providers.' . $key . '.client_id', $provider['client_id'])" />
                                        </div>
                                        <div>
                                            <x-input-label :value="__('Client Secret')" />
                                            <div class="relative mt-1">
                                                <x-text-input id="{{ $secretId }}" name="providers[{{ $key }}][client_secret]" type="password" class="pr-12" :value="old('providers.' . $key . '.client_secret', $provider['client_secret'])" />
                                                <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="{{ $secretId }}" aria-label="Toggle password visibility">
                                                    <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                                                        <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                                                        <circle cx="12" cy="12" r="3"></circle>
                                                    </svg>
                                                    <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                                                        <path d="M3 5l16 16"></path>
                                                        <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                                                        <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                                                        <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                                                    </svg>
                                                </button>
                                            </div>
                                        </div>
                                        <div>
                                            <x-input-label :value="__('Redirect URL')" />
                                            <x-text-input name="providers[{{ $key }}][redirect_url]" type="url" class="mt-1" :value="old('providers.' . $key . '.redirect_url', $provider['redirect_url'])" />
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Social Login') }}</button>
                        </div>
                    </form>
                </div>
                <div data-tab-panel="gdpr">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'gdpr') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Cookie Banner') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div class="lg:col-span-2">
                                    <x-input-label :value="__('Enable GDPR Message')" />
                                    <input type="hidden" name="gdpr_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="gdpr_enabled" value="1" class="peer sr-only" @checked((bool) old('gdpr_enabled', $settings['gdpr']['gdpr_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('gdpr_enabled', $settings['gdpr']['gdpr_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div class="lg:col-span-2">
                                    <x-input-label for="gdpr_message" :value="__('GDPR Message')" />
                                    <textarea id="gdpr_message" name="gdpr_message" rows="4" class="input-field mt-1" data-no-wysiwyg>{{ old('gdpr_message', $settings['gdpr']['gdpr_message']) }}</textarea>
                                    <x-input-error :messages="$errors->get('gdpr_message')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="gdpr_accept_label" :value="__('Accept Button Label')" />
                                    <x-text-input id="gdpr_accept_label" name="gdpr_accept_label" type="text" class="mt-1" :value="old('gdpr_accept_label', $settings['gdpr']['gdpr_accept_label'])" />
                                    <x-input-error :messages="$errors->get('gdpr_accept_label')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="gdpr_decline_label" :value="__('Decline Button Label')" />
                                    <x-text-input id="gdpr_decline_label" name="gdpr_decline_label" type="text" class="mt-1" :value="old('gdpr_decline_label', $settings['gdpr']['gdpr_decline_label'])" />
                                    <x-input-error :messages="$errors->get('gdpr_decline_label')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save GDPR Settings') }}</button>
                        </div>
                    </form>
                </div>

                <div data-tab-panel="maintenance">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'maintenance') }}" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Maintenance Mode') }}</p>
                            <div class="mt-4 grid gap-4">
                                <div>
                                    <x-input-label :value="__('Enable Maintenance Mode')" />
                                    <input type="hidden" name="maintenance_enabled" value="0">
                                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                        <input type="checkbox" name="maintenance_enabled" value="1" class="peer sr-only" @checked((bool) old('maintenance_enabled', $settings['maintenance']['maintenance_enabled']))>
                                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                        </span>
                                        <span>{{ old('maintenance_enabled', $settings['maintenance']['maintenance_enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                    </label>
                                </div>
                                <div>
                                    <x-input-label for="maintenance_message" :value="__('Maintenance Message')" />
                                    <textarea id="maintenance_message" name="maintenance_message" rows="4" class="input-field mt-1" data-no-wysiwyg>{{ old('maintenance_message', $settings['maintenance']['maintenance_message']) }}</textarea>
                                    <x-input-error :messages="$errors->get('maintenance_message')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save Maintenance Settings') }}</button>
                        </div>
                    </form>
                </div>

                <div data-tab-panel="pwa">
                    <form method="POST" action="{{ route('admin.system-settings.update', 'pwa') }}" enctype="multipart/form-data" class="space-y-6">
                        @csrf
                        @method('POST')

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Progressive Web App') }}</p>
                            <p class="mt-1 text-sm text-muted">{{ __('Allow users to install SnapNest on their device from the browser. Requires HTTPS.') }}</p>
                            <div class="mt-4">
                                <x-input-label :value="__('Enable PWA')" />
                                <input type="hidden" name="pwa_enabled" value="0">
                                <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                                    <input type="checkbox" name="pwa_enabled" value="1" class="peer sr-only" @checked((bool) old('pwa_enabled', $settings['pwa']['enabled']))>
                                    <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                                        <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                                    </span>
                                    <span>{{ old('pwa_enabled', $settings['pwa']['enabled']) ? __('Enabled') : __('Disabled') }}</span>
                                </label>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('App Identity') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="pwa_app_name" :value="__('App Name')" />
                                    <x-text-input id="pwa_app_name" name="app_name" type="text" class="mt-1" placeholder="{{ config('app.name', 'SnapNest') }}" :value="old('app_name', $settings['pwa']['app_name'])" />
                                    <p class="mt-1 text-xs text-muted">{{ __('Shown on the home screen after install.') }}</p>
                                    <x-input-error :messages="$errors->get('app_name')" class="mt-2" />
                                </div>
                                <div>
                                    <x-input-label for="pwa_app_url" :value="__('Start URL')" />
                                    <x-text-input id="pwa_app_url" name="app_url" type="text" class="mt-1" placeholder="/" :value="old('app_url', $settings['pwa']['app_url'])" />
                                    <p class="mt-1 text-xs text-muted">{{ __('Page opened when launched from home screen.') }}</p>
                                    <x-input-error :messages="$errors->get('app_url')" class="mt-2" />
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Icons &amp; Splash Screen') }}</p>
                            <div class="mt-4 grid gap-6 lg:grid-cols-2">
                                <div class="flex items-center gap-4">
                                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                        <img src="{{ $settings['pwa']['icon'] ? asset('storage/' . $settings['pwa']['icon']) : asset('images/placeholder-media.svg') }}" alt="PWA Icon" class="h-full w-full object-cover">
                                    </div>
                                    <div>
                                        <x-input-label for="pwa_icon" :value="__('PWA Icon')" />
                                        <input id="pwa_icon" name="icon" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                                        <p class="mt-1 text-xs text-muted">{{ __('Recommended: 512×512 px PNG.') }}</p>
                                        <x-input-error :messages="$errors->get('icon')" class="mt-2" />
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                                        <img src="{{ $settings['pwa']['splash_screen'] ? asset('storage/' . $settings['pwa']['splash_screen']) : asset('images/placeholder-media.svg') }}" alt="Splash Screen" class="h-full w-full object-cover">
                                    </div>
                                    <div>
                                        <x-input-label for="pwa_splash" :value="__('Splash Screen')" />
                                        <input id="pwa_splash" name="splash_screen" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                                        <p class="mt-1 text-xs text-muted">{{ __('iOS only. Recommended: 2048×2732 px.') }}</p>
                                        <x-input-error :messages="$errors->get('splash_screen')" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="panel p-6">
                            <p class="panel-heading">{{ __('Colors') }}</p>
                            <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                <div>
                                    <x-input-label for="pwa_theme_color" :value="__('Theme Color')" />
                                    <div class="mt-1 flex items-center gap-3">
                                        <input type="color" id="pwa_theme_color" name="theme_color" value="{{ old('theme_color', $settings['pwa']['theme_color']) }}" class="h-11 w-16 cursor-pointer rounded-xl border border-border bg-transparent p-1">
                                        <x-text-input id="pwa_theme_color_text" name="" type="text" class="flex-1" :value="old('theme_color', $settings['pwa']['theme_color'])" oninput="document.getElementById('pwa_theme_color').value=this.value" />
                                    </div>
                                    <p class="mt-1 text-xs text-muted">{{ __('Browser toolbar and task switcher color.') }}</p>
                                </div>
                                <div>
                                    <x-input-label for="pwa_bg_color" :value="__('Background Color')" />
                                    <div class="mt-1 flex items-center gap-3">
                                        <input type="color" id="pwa_bg_color" name="background_color" value="{{ old('background_color', $settings['pwa']['background_color']) }}" class="h-11 w-16 cursor-pointer rounded-xl border border-border bg-transparent p-1">
                                        <x-text-input id="pwa_bg_color_text" name="" type="text" class="flex-1" :value="old('background_color', $settings['pwa']['background_color'])" oninput="document.getElementById('pwa_bg_color').value=this.value" />
                                    </div>
                                    <p class="mt-1 text-xs text-muted">{{ __('Splash screen background before the app loads.') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="btn-primary">{{ __('Save PWA Settings') }}</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</x-admin-layout>

