<x-admin-layout :title="__('Ticket Assignments')" :subtitle="__('Route tickets to support agents and track ownership.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Assignments') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Keep assignment history and active ownership visible.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-ticket-assignments')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/ticket-assignments.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.ticket-assignments.create') }}" class="btn-primary">{{ __('Add Assignment') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.5fr,1fr,1fr,1fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search by ticket or subject') }}">
                </div>
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="">{{ __('All statuses') }}</option>
                        <option value="active" @selected($status === 'active')>{{ __('Active') }}</option>
                        <option value="inactive" @selected($status === 'inactive')>{{ __('Inactive') }}</option>
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="ticket">{{ __('Ticket') }}</label>
                    <select id="ticket" name="ticket" class="input-field">
                        <option value="">{{ __('All tickets') }}</option>
                        @foreach ($tickets as $ticket)
                            <option value="{{ $ticket->id }}" @selected((string) $ticketFilter === (string) $ticket->id)>
                                {{ $ticket->ticket_number }} - {{ $ticket->subject }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="assignee">{{ __('Assignee') }}</label>
                    <select id="assignee" name="assignee" class="input-field">
                        <option value="">{{ __('All assignees') }}</option>
                        @foreach ($agents as $agent)
                            <option value="{{ $agent->id }}" @selected((string) $assignee === (string) $agent->id)>{{ $agent->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="sr-only" for="sort">{{ __('Sort') }}</label>
                    <select id="sort" name="sort" class="input-field">
                        <option value="latest" @selected($sort === 'latest')>{{ __('Newest') }}</option>
                        <option value="oldest" @selected($sort === 'oldest')>{{ __('Oldest') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.ticket-assignments.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="ticket-assignments-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Assignment Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing') }} {{ $assignments->count() }} {{ __('of') }} {{ $assignments->total() }} {{ __('assignments.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.ticket-assignments.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-ticket-assignment-bulk-delete">{{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('Ticket') }}</th>
                            <th class="pb-3">{{ __('Assignee') }}</th>
                            <th class="pb-3">{{ __('Assigned By') }}</th>
                            <th class="pb-3">{{ __('Assigned At') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($assignments as $assignment)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $assignment->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $assignment->ticket?->subject ?? __('Ticket unavailable') }}</p>
                                    <p class="text-xs text-muted">{{ $assignment->ticket?->ticket_number ?? __('N/A') }}</p>
                                </td>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $assignment->assignedTo?->name ?? __('Unassigned') }}</p>
                                    <p class="text-xs text-muted">{{ $assignment->assignedTo?->email ?? __('No email') }}</p>
                                </td>
                                <td class="py-4">
                                    <p class="text-sm text-ink">{{ $assignment->assignedBy?->name ?? __('System') }}</p>
                                    <p class="text-xs text-muted">{{ $assignment->assignedBy?->email ?? '' }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">{{ $assignment->assigned_at ? \App\Support\FormatSettings::dateTime($assignment->assigned_at) : __('Not set') }}</td>
                                <td class="py-4 text-sm text-ink">{{ $assignment->is_active ? __('Active') : __('Inactive') }}</td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.ticket-assignments.show', $assignment) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.ticket-assignments.edit', $assignment) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-ticket-assignment-delete-{{ $assignment->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-ticket-assignment-delete-{{ $assignment->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.ticket-assignments.destroy', $assignment) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete this assignment?') }}</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="py-6 text-center text-sm text-muted">{{ __('No assignments found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($assignments as $assignment)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="font-semibold text-ink">{{ $assignment->ticket?->subject ?? __('Ticket unavailable') }}</p>
                                <p class="text-xs text-muted">{{ $assignment->ticket?->ticket_number ?? __('N/A') }}</p>
                            </div>
                            <span class="badge">{{ $assignment->is_active ? __('Active') : __('Inactive') }}</span>
                        </div>
                        <div class="mt-3 text-sm text-ink">{{ $assignment->assignedTo?->name ?? __('Unassigned') }}</div>
                        <div class="mt-1 text-xs text-muted">{{ $assignment->assignedTo?->email ?? __('No email') }}</div>
                        <div class="mt-3 text-xs text-muted">{{ __('Assigned at') }} {{ $assignment->assigned_at ? \App\Support\FormatSettings::dateTime($assignment->assigned_at) : __('Not set') }}
                        </div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.ticket-assignments.show', $assignment) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.ticket-assignments.edit', $assignment) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No assignments found.') }}</div>
                @endforelse
            </div>

            <x-modal name="confirm-ticket-assignment-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.ticket-assignments.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected assignments?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> assignment(s).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="import-ticket-assignments" :show="false" focusable>
                <form method="POST" action="{{ route('admin.ticket-assignments.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Ticket Assignments') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="ticket_assignments_file" :value="__('CSV File')" />
                        <input id="ticket_assignments_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $assignments->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
