﻿@php
    $isEdit = isset($assignment) && $assignment;
    $selectedTicket = old('support_ticket_id', $isEdit ? $assignment->support_ticket_id : null);
    $selectedAssignee = old('assigned_to', $isEdit ? $assignment->assigned_to : null);
@endphp

<div class="grid gap-6 lg:grid-cols-2">
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Assignment') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label for="support_ticket_id" :value="__('Support Ticket')" />
                <select id="support_ticket_id" name="support_ticket_id" class="input-field mt-1" required>
                    <option value="">{{ __('Select ticket') }}</option>
                    @foreach ($tickets as $ticket)
                        <option value="{{ $ticket->id }}" @selected((string) $selectedTicket === (string) $ticket->id)>
                            {{ $ticket->ticket_number }} - {{ $ticket->subject }}
                        </option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('support_ticket_id')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="assigned_to" :value="__('Assign To')" />
                <select id="assigned_to" name="assigned_to" class="input-field mt-1" required>
                    <option value="">{{ __('Select agent') }}</option>
                    @foreach ($agents as $agent)
                        <option value="{{ $agent->id }}" @selected((string) $selectedAssignee === (string) $agent->id)>{{ $agent->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('assigned_to')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="assigned_at" :value="__('Assigned At')" />
                <x-text-input id="assigned_at" name="assigned_at" type="datetime-local" class="mt-1" :value="old('assigned_at', $isEdit && $assignment->assigned_at ? $assignment->assigned_at->format('Y-m-d\TH:i') : '')" />
                <x-input-error :messages="$errors->get('assigned_at')" class="mt-2" />
            </div>
            <div>
                <x-input-label for="note" :value="__('Note')" />
                <x-text-input id="note" name="note" type="text" class="mt-1" :value="old('note', $isEdit ? $assignment->note : '')" placeholder="{{ __('Add assignment context') }}" />
                <x-input-error :messages="$errors->get('note')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Status') }}</p>
        <div class="mt-4">
            <x-input-label :value="__('Active Assignment')" />
            <input type="hidden" name="is_active" value="0">
            <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $assignment->is_active : true))>
                <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                    <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                </span>
                <span>{{ old('is_active', $isEdit ? $assignment->is_active : true) ? __('Active') : __('Inactive') }}</span>
            </label>
        </div>
    </div>
</div>

