<x-admin-layout :title="__('Assignment Details')" :subtitle="__('Review ticket ownership and assignment history.')">
    @php
        $ticketStatus = $assignment->ticket?->status;
        $ticketPriority = $assignment->ticket?->priority;
    @endphp

    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-start justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Ticket Assignment') }}</p>
                    <h2 class="mt-2 text-xl font-semibold text-ink">{{ $assignment->ticket?->subject ?? __('Ticket unavailable') }}</h2>
                    <p class="mt-1 text-sm text-muted">{{ $assignment->ticket?->ticket_number ?? __('N/A') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <a href="{{ route('admin.ticket-assignments.index') }}" class="btn-secondary">{{ __('Back') }}</a>
                    <a href="{{ route('admin.ticket-assignments.edit', $assignment) }}" class="btn-primary">{{ __('Edit Assignment') }}</a>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-4">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Assignee') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $assignment->assignedTo?->name ?? __('Unassigned') }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $assignment->assignedTo?->email ?? __('No email') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Assigned By') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $assignment->assignedBy?->name ?? __('System') }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $assignment->assignedBy?->email ?? __('N/A') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Assigned At') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $assignment->assigned_at ? \App\Support\FormatSettings::dateTime($assignment->assigned_at) : __('Not set') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $assignment->is_active ? __('Active') : __('Inactive') }}</p>
                </div>
            </div>

            <div class="mt-6 grid gap-4 lg:grid-cols-3">
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Requester') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $assignment->ticket?->requester_name ?? __('N/A') }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $assignment->ticket?->requester_email ?? __('N/A') }}</p>
                    <p class="mt-1 text-xs text-muted">{{ $assignment->ticket?->requester_phone ?? __('No phone provided') }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Ticket Status') }}</p>
                    <p class="mt-2 text-sm font-semibold text-ink">{{ $ticketStatus ? ucfirst(str_replace('_', ' ', $ticketStatus)) : 'Unknown' }}</p>
                    <p class="mt-1 text-xs text-muted">{{ __('Priority:') }} {{ $ticketPriority ? ucfirst($ticketPriority) : 'Unknown' }}</p>
                </div>
                <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4">
                    <p class="panel-heading">{{ __('Note') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ $assignment->note ?: __('No notes added.') }}</p>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
