<x-admin-layout :title="__('Account Usage')" :subtitle="__('Monitor your plan limits and remaining balance.')">
@php
    function usageFormatBytes($bytes, $isLimit = false) {
        if ($isLimit && ($bytes === null || $bytes <= 0)) return __('Unlimited');
        if ($bytes <= 0) return '0 B';
        $units = ['B', 'KB', 'MB', 'GB', 'TB'];
        $power = (int) floor(log($bytes, 1024));
        return number_format($bytes / (1024 ** $power), 1) . ' ' . $units[$power];
    }
    function usagePct($used, $limit) {
        if (!$limit || $limit <= 0) return 0;
        return min(100, round(($used / $limit) * 100));
    }
    function usageBarColor($pct) {
        if ($pct >= 90) return 'bg-red-500';
        if ($pct >= 70) return 'bg-amber-500';
        return 'bg-green-500';
    }
@endphp

<div class="space-y-6">

    {{-- ── Plan Overview Header ──────────────────────────────────── --}}
    <div class="panel p-6">
        <div class="flex flex-wrap items-center justify-between gap-4">
            <div>
                <h2 class="text-xl font-semibold text-ink">
                    {{ __('Current Plan:') }} <span class="text-brand">{{ $usage['plan'] ? $usage['plan']->name : __('Free') }}</span>
                </h2>
                <p class="mt-1 text-sm text-muted">{{ __('Your quotas and feature access based on your active subscription.') }}</p>
            </div>
            <div class="flex items-center gap-3">
                @if($usage['plan'])
                    <div class="badge badge-success px-4 py-2 text-sm font-semibold">{{ __('Active') }}</div>
                    @if($usage['plan']->price > 0)
                        <span class="text-sm text-muted font-medium">
                            {{ \App\Support\FormatSettings::currencyConfig()['symbol'] }}{{ number_format($usage['plan']->price, 2) }} / {{ $usage['plan']->billing_cycle ?? 'mo' }}
                        </span>
                    @else
                        <span class="badge badge-warning px-4 py-2 text-sm">{{ __('Free Tier') }}</span>
                    @endif
                @else
                    <span class="badge badge-warning px-4 py-2 text-sm">{{ __('No Plan') }}</span>
                @endif
                <a href="{{ route('pricing') }}" target="_blank" class="btn btn-outline btn-sm">{{ __('Upgrade Plan') }}</a>
            </div>
        </div>
    </div>

    {{-- ── Quota Bars ──────────────────────────────────────────────── --}}
    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-4">

        {{-- Events --}}
        @php $pct = usagePct($usage['events']['used'], $usage['events']['limit']); @endphp
        <div class="panel p-6">
            <div class="flex items-center gap-3 mb-4">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-blue-500/10 text-blue-500">
                    <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2"/><line x1="16" y1="2" x2="16" y2="6"/><line x1="8" y1="2" x2="8" y2="6"/><line x1="3" y1="10" x2="21" y2="10"/></svg>
                </div>
                <h3 class="font-semibold text-ink">{{ __('Active Events') }}</h3>
            </div>
            <p class="text-3xl font-bold text-ink">{{ number_format($usage['events']['used']) }}</p>
            <p class="text-sm text-muted mt-1">{{ __('of') }} {{ $usage['events']['limit'] ? number_format($usage['events']['limit']) : __('Unlimited') }}</p>
            @if($usage['events']['limit'])
                <div class="mt-3 flex items-center justify-between text-xs text-muted mb-1">
                    <span>{{ __('Used') }}</span><span>{{ $pct }}%</span>
                </div>
                <div class="h-2 w-full rounded-full bg-surface-2/50 overflow-hidden">
                    <div class="h-full rounded-full transition-all duration-500 {{ usageBarColor($pct) }}" style="width:{{ $pct }}%"></div>
                </div>
                @if($pct >= 90)<p class="text-xs text-red-500 mt-2 font-medium">{{ __('⚠ Limit almost reached') }}</p>@endif
            @endif
        </div>

        {{-- Images --}}
        @php $pct = usagePct($usage['images']['used'], $usage['images']['limit']); @endphp
        <div class="panel p-6">
            <div class="flex items-center gap-3 mb-4">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-500/10 text-emerald-500">
                    <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2"/><circle cx="8.5" cy="8.5" r="1.5"/><polyline points="21 15 16 10 5 21"/></svg>
                </div>
                <h3 class="font-semibold text-ink">{{ __('Photos') }}</h3>
            </div>
            <p class="text-3xl font-bold text-ink">{{ number_format($usage['images']['used']) }}</p>
            <p class="text-sm text-muted mt-1">{{ __('of') }} {{ $usage['images']['limit'] ? number_format($usage['images']['limit']) : __('Unlimited') }}</p>
            @if($usage['images']['limit'])
                <div class="mt-3 flex items-center justify-between text-xs text-muted mb-1">
                    <span>{{ __('Used') }}</span><span>{{ $pct }}%</span>
                </div>
                <div class="h-2 w-full rounded-full bg-surface-2/50 overflow-hidden">
                    <div class="h-full rounded-full transition-all duration-500 {{ usageBarColor($pct) }}" style="width:{{ $pct }}%"></div>
                </div>
                @if($pct >= 90)<p class="text-xs text-red-500 mt-2 font-medium">{{ __('⚠ Limit almost reached') }}</p>@endif
            @endif
        </div>

        {{-- Videos --}}
        @php $pct = usagePct($usage['videos']['used'], $usage['videos']['limit']); @endphp
        <div class="panel p-6">
            <div class="flex items-center gap-3 mb-4">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-pink-500/10 text-pink-500">
                    <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="23 7 16 12 23 17 23 7"/><rect x="1" y="5" width="15" height="14" rx="2"/></svg>
                </div>
                <h3 class="font-semibold text-ink">{{ __('Videos') }}</h3>
            </div>
            <p class="text-3xl font-bold text-ink">{{ number_format($usage['videos']['used']) }}</p>
            <p class="text-sm text-muted mt-1">{{ __('of') }} {{ $usage['videos']['limit'] ? number_format($usage['videos']['limit']) : __('Unlimited') }}</p>
            @if($usage['videos']['limit'])
                <div class="mt-3 flex items-center justify-between text-xs text-muted mb-1">
                    <span>{{ __('Used') }}</span><span>{{ $pct }}%</span>
                </div>
                <div class="h-2 w-full rounded-full bg-surface-2/50 overflow-hidden">
                    <div class="h-full rounded-full transition-all duration-500 {{ usageBarColor($pct) }}" style="width:{{ $pct }}%"></div>
                </div>
                @if($pct >= 90)<p class="text-xs text-red-500 mt-2 font-medium">{{ __('⚠ Limit almost reached') }}</p>@endif
            @endif
        </div>

        {{-- Storage --}}
        @php $pct = usagePct($usage['storage']['used'], $usage['storage']['limit']); @endphp
        <div class="panel p-6">
            <div class="flex items-center gap-3 mb-4">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-purple-500/10 text-purple-500">
                    <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/><polyline points="3.27 6.96 12 12.01 20.73 6.96"/><line x1="12" y1="22.08" x2="12" y2="12"/></svg>
                </div>
                <h3 class="font-semibold text-ink">{{ __('Storage') }}</h3>
            </div>
            <p class="text-3xl font-bold text-ink">{{ usageFormatBytes($usage['storage']['used']) }}</p>
            <p class="text-sm text-muted mt-1">{{ __('of') }} {{ usageFormatBytes($usage['storage']['limit'], true) }}</p>
            @if($usage['storage']['limit'] > 0)
                <div class="mt-3 flex items-center justify-between text-xs text-muted mb-1">
                    <span>{{ __('Used') }}</span><span>{{ $pct }}%</span>
                </div>
                <div class="h-2 w-full rounded-full bg-surface-2/50 overflow-hidden">
                    <div class="h-full rounded-full transition-all duration-500 {{ usageBarColor($pct) }}" style="width:{{ $pct }}%"></div>
                </div>
                @if($pct >= 90)<p class="text-xs text-red-500 mt-2 font-medium">{{ __('⚠ Limit almost reached') }}</p>@endif
            @endif
        </div>
    </div>

    {{-- Max file size info --}}
    @if($usage['max_file_size_mb'])
    <div class="panel p-4 flex items-center gap-3 text-sm">
        <svg viewBox="0 0 24 24" class="h-4 w-4 text-muted shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/><polyline points="14 2 14 8 20 8"/></svg>
        <span class="text-muted">{{ __('Max upload file size:') }} <strong class="text-ink">{{ $usage['max_file_size_mb'] }} MB</strong> {{ __('per file') }}</span>
    </div>
    @endif

    {{-- ── Features Grid ───────────────────────────────────────────── --}}
    <div class="panel p-6">
        <h3 class="text-lg font-semibold text-ink mb-6">{{ __('Plan Features') }}</h3>
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">

            @php
            $features = [
                ['key' => 'has_watermark',           'label' => 'Watermark',            'desc_on' => 'System watermark applied to your images.',         'desc_off' => 'No watermark on your photos.',              'invert' => true,
                 'icon' => '<path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>'],
                ['key' => 'has_design_editor',       'label' => 'Design Editor',        'desc_on' => 'Customize event pages with full design control.',   'desc_off' => 'Upgrade to access the custom design editor.','invert' => false,
                 'icon' => '<path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"/>'],
                ['key' => 'has_guest_upload',        'label' => 'Guest Uploads',        'desc_on' => 'Guests can contribute their own photos to events.',  'desc_off' => 'Upgrade to allow guests to upload photos.',  'invert' => false,
                 'icon' => '<path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/><polyline points="17 8 12 3 7 8"/><line x1="12" y1="3" x2="12" y2="15"/>'],
                ['key' => 'has_google_drive_import', 'label' => 'Google Drive Import', 'desc_on' => 'Import albums directly from Google Drive.',           'desc_off' => 'Upgrade to import from Google Drive.',      'invert' => false,
                 'icon' => '<path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07A19.5 19.5 0 0 1 4.15 12"/><polyline points="22 4 12 14.01 9 11.01"/>'],
                ['key' => 'has_ftp_import',          'label' => 'FTP / Camera Import', 'desc_on' => 'Auto-import photos via WiFi FTP from your camera.',  'desc_off' => 'Upgrade to use FTP camera tethering.',      'invert' => false,
                 'icon' => '<path d="M15 7h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-2"/><path d="M6 7H5a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2"/><circle cx="12" cy="12" r="3"/>'],
                ['key' => 'has_custom_branding',     'label' => 'Custom Branding',     'desc_on' => 'Remove platform branding from your galleries.',     'desc_off' => 'Upgrade to remove platform branding.',      'invert' => false,
                 'icon' => '<circle cx="12" cy="12" r="10"/><path d="M8.56 2.75c4.37 6.03 6.02 9.42 8.03 17.72m2.54-15.38c-3.72 4.35-8.94 5.66-16.88 5.85m19.5 1.9c-3.5-.93-6.63-.82-8.94 0-2.58.92-5.01 2.86-7.44 6.32"/>'],
                ['key' => 'has_cloud_storage',       'label' => 'Cloud Storage',       'desc_on' => 'Media stored on cloud (S3/GCS) for scalability.',    'desc_off' => 'Upgrade to enable cloud storage (S3/GCS).', 'invert' => false,
                 'icon' => '<path d="M17.5 19H9a7 7 0 1 1 6.71-9h1.79a4.5 4.5 0 1 1 0 9Z"/>'],
            ];
            @endphp

            @foreach($features as $feat)
            @php
                $enabled = $usage['features'][$feat['key']];
                $positive = $feat['invert'] ? !$enabled : $enabled;
            @endphp
            <div class="flex items-start gap-4 p-4 rounded-2xl bg-surface-2/50 border border-border/50">
                <div @class([
                    'flex h-9 w-9 shrink-0 items-center justify-center rounded-full',
                    'bg-green-500/10 text-green-600' => $positive,
                    'bg-red-500/10 text-red-400' => !$positive,
                ])>
                    <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        @if($positive)
                            <polyline points="20 6 9 17 4 12"/>
                        @else
                            <line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/>
                        @endif
                    </svg>
                </div>
                <div class="min-w-0">
                    <div class="flex items-center gap-2">
                        <p class="font-semibold text-ink text-sm">{{ $feat['label'] }}</p>
                        <span @class(['text-[10px] font-bold px-1.5 py-0.5 rounded-full', 'bg-green-100 text-green-700' => $positive, 'bg-red-100 text-red-600' => !$positive])>
                            {{ $positive ? __('Enabled') : __('Locked') }}
                        </span>
                    </div>
                    <p class="text-xs text-muted mt-1 leading-relaxed">
                        {{ $positive ? $feat['desc_on'] : $feat['desc_off'] }}
                    </p>
                </div>
            </div>
            @endforeach

        </div>
    </div>

    {{-- ── Upgrade Banner ──────────────────────────────────────────── --}}
    @if(!$usage['plan'] || $usage['plan']->price <= 0)
    <div class="panel p-6 bg-brand text-white overflow-hidden relative">
        <div class="relative z-10 flex flex-wrap items-center justify-between gap-6">
            <div class="max-w-xl">
                <h3 class="text-2xl font-bold">{{ __('Unlock Higher Limits & Pro Features') }}</h3>
                <p class="mt-2 text-white/80">{{ __('Upgrade to get more storage, more events, remove watermarks, guest uploads, cloud storage, and the design editor.') }}</p>
            </div>
            <a href="{{ route('pricing') }}" target="_blank" class="rounded-full bg-white px-8 py-3 font-semibold text-brand hover:bg-white/90 transition-colors">{{ __('Upgrade Now →') }}</a>
        </div>
        <div class="absolute -right-16 -top-16 h-64 w-64 rounded-full bg-brand-strong/20"></div>
        <div class="absolute -left-8 -bottom-8 h-32 w-32 rounded-full bg-brand-strong/20"></div>
    </div>
    @endif

</div>
</x-admin-layout>
