<x-admin-layout :title="__('User Delete Requests')" :subtitle="__('Review and act on account deletion requests.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Requests') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing') }} {{ $requests->count() }} {{ __('of') }} {{ $requests->total() }} {{ __('requests.') }}</p>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="status">{{ __('Status') }}</label>
                    <select id="status" name="status" class="input-field">
                        <option value="pending" @selected($status === 'pending')>{{ __('Pending') }}</option>
                        <option value="accepted" @selected($status === 'accepted')>{{ __('Accepted') }}</option>
                        <option value="rejected" @selected($status === 'rejected')>{{ __('Rejected') }}</option>
                        <option value="all" @selected($status === 'all')>{{ __('All') }}</option>
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.user-delete-requests.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6">
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">{{ __('User') }}</th>
                            <th class="pb-3">{{ __('Requested') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3">{{ __('Processed By') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($requests as $requestItem)
                            <tr>
                                <td class="py-4">
                                    <p class="font-semibold text-ink">{{ $requestItem->user?->name ?? $requestItem->user_name ?? __('Unknown') }}</p>
                                    <p class="text-xs text-muted">{{ $requestItem->user?->email ?? $requestItem->user_email ?? '-' }}</p>
                                </td>
                                <td class="py-4 text-sm text-ink">
                                    {{ $requestItem->created_at ? \App\Support\FormatSettings::dateTime($requestItem->created_at) : 'N/A' }}
                                </td>
                                <td class="py-4">
                                    <span class="badge">{{ ucfirst($requestItem->status) }}</span>
                                </td>
                                <td class="py-4 text-sm text-ink">
                                    {{ $requestItem->processor?->name ?? __('N/A') }}
                                </td>
                                <td class="py-4 text-right">
                                    @if ($requestItem->status === \App\Models\UserDeleteRequest::STATUS_PENDING)
                                        <div class="inline-flex items-center gap-2">
                                            <form method="POST" action="{{ route('admin.user-delete-requests.update', $requestItem) }}">
                                                @csrf
                                                @method('PATCH')
                                                <input type="hidden" name="action" value="accept">
                                                <button type="submit" class="btn-primary">{{ __('Accept') }}</button>
                                            </form>
                                            <form method="POST" action="{{ route('admin.user-delete-requests.update', $requestItem) }}">
                                                @csrf
                                                @method('PATCH')
                                                <input type="hidden" name="action" value="reject">
                                                <button type="submit" class="btn-danger">{{ __('Reject') }}</button>
                                            </form>
                                        </div>
                                    @else
                                        <span class="text-xs text-muted">{{ __('Processed') }}</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="py-6 text-center text-sm text-muted">{{ __('No delete requests found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6">
                {{ $requests->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
