<x-admin-layout :title="__('Edit User')" :subtitle="__('Update account details, roles, and verification state.')">
    <div class="space-y-6">
        <div class="flex flex-wrap items-center justify-between gap-4">
            <a href="{{ route('admin.users.index') }}" class="btn-secondary">{{ __('Back to Users') }}</a>
            <div class="text-sm text-muted">Last updated {{ $user->updated_at?->diffForHumans() ?? 'recently' }}.</div>
        </div>

        <form method="POST" action="{{ route('admin.users.update', $user) }}" enctype="multipart/form-data" class="space-y-6">
            @csrf
            @method('PUT')

            @include('admin.users.partials.form', ['user' => $user])

            <div class="flex flex-wrap items-center justify-end gap-3">
                <button type="submit" class="btn-primary">{{ __('Update User') }}</button>
            </div>
        </form>
    </div>
</x-admin-layout>
