<x-admin-layout :title="__('User Management')" :subtitle="__('Control access, roles, and verification across your team and clients.')">
    <div class="space-y-6">
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Users') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Search by name or email, then assign the right role.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <button type="button" class="btn-secondary" x-data="" x-on:click.prevent="$dispatch('open-modal', 'import-users')">{{ __('Import CSV') }}</button>
                    <a href="{{ asset('templates/users.csv') }}" class="btn-secondary">{{ __('Download Template') }}</a>
                    <a href="{{ route('admin.users.create') }}" class="btn-primary">{{ __('Add User') }}</a>
                </div>
            </div>

            <form method="get" class="filter-form mt-6 grid gap-4 lg:grid-cols-[1.5fr,1fr,auto] sm:grid-cols-2">
                <div>
                    <label class="sr-only" for="search">{{ __('Search') }}</label>
                    <input id="search" name="search" value="{{ $search }}" class="input-field" placeholder="{{ __('Search by name or email') }}">
                </div>
                <div>
                    <label class="sr-only" for="role">{{ __('Role') }}</label>
                    <select id="role" name="role" class="input-field">
                        <option value="">{{ __('All roles') }}</option>
                        @foreach ($roles as $role)
                            <option value="{{ $role->name }}" @selected($roleFilter === $role->name)>{{ $role->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="flex items-center gap-3">
                    <button class="btn-secondary" type="submit">{{ __('Filter') }}</button>
                    <a href="{{ route('admin.users.index') }}" class="btn-secondary">{{ __('Reset') }}</a>
                </div>
            </form>
        </div>

        <div class="panel p-6" data-bulk-scope data-view-scope data-view-mode="list" data-view-storage="users-view">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading">{{ __('Active Directory') }}</p>
                    <p class="mt-2 text-sm text-muted">{{ __('Showing') }} {{ $users->count() }} {{ __('of') }} {{ $users->total() }} {{ __('users.') }}</p>
                </div>
                <div class="flex flex-wrap items-center gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="btn-secondary" data-view-toggle="list">{{ __('List') }}</button>
                        <button type="button" class="btn-secondary" data-view-toggle="grid">{{ __('Grid') }}</button>
                    </div>
                    <button type="button" class="btn-secondary" onclick="window.print()">{{ __('Print') }}</button>
                    <a href="{{ route('admin.users.export', request()->query()) }}" class="btn-secondary">{{ __('Export CSV') }}</a>
                    <button type="button" class="btn-danger hidden" data-bulk-action data-bulk-modal="confirm-user-bulk-delete">{{ __('Bulk Delete') }} (<span data-bulk-count>0</span>)
                    </button>
                </div>
            </div>

            <div class="mt-6 overflow-x-auto view-list">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3">
                                <input type="checkbox" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-all>
                            </th>
                            <th class="pb-3">{{ __('User') }}</th>
                            <th class="pb-3">{{ __('Role') }}</th>
                            <th class="pb-3">{{ __('Status') }}</th>
                            <th class="pb-3 text-right">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        @forelse ($users as $user)
                            <tr>
                                <td class="py-4">
                                    <input type="checkbox" value="{{ $user->id }}" class="h-4 w-4 rounded border-border bg-surface-2/80 text-brand focus:ring-brand/40" data-bulk-item>
                                </td>
                                <td class="py-4">
                                    <div class="flex items-center gap-3">
                                        <span class="h-10 w-10 overflow-hidden rounded-full border border-border bg-surface-2/80">
                                            @if ($user->profile_photo_path)
                                                <img src="{{ asset('storage/' . $user->profile_photo_path) }}" alt="{{ $user->name }}" class="h-full w-full object-cover">
                                            @else
                                                <img src="{{ asset('images/placeholder-user.svg') }}" alt="Placeholder avatar" class="h-full w-full object-cover">
                                            @endif
                                        </span>
                                        <div>
                                            <p class="font-semibold text-ink">{{ $user->name }}</p>
                                            <p class="text-xs text-muted">{{ $user->email }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4">
                                    <div class="flex flex-wrap gap-2">
                                        @forelse ($user->roles as $role)
                                            <span class="badge">{{ $role->name }}</span>
                                        @empty
                                            <span class="badge">{{ __('Unassigned') }}</span>
                                        @endforelse
                                    </div>
                                </td>
                                <td class="py-4">
                                    <span class="text-sm font-semibold text-ink">{{ $user->is_active ? __('Active') : __('Inactive') }}</span>
                                </td>
                                <td class="py-4 text-right">
                                    <div class="inline-flex items-center gap-2">
                                        <a href="{{ route('admin.users.show', $user) }}" class="btn-secondary">{{ __('View') }}</a>
                                        <a href="{{ route('admin.users.edit', $user) }}" class="btn-secondary">{{ __('Edit') }}</a>
                                        <button type="button" class="btn-danger" x-data="" x-on:click.prevent="$dispatch('open-modal', 'confirm-user-delete-{{ $user->id }}')">{{ __('Delete') }}</button>
                                    </div>

                                    <x-modal name="confirm-user-delete-{{ $user->id }}" :show="false" focusable>
                                        <form method="POST" action="{{ route('admin.users.destroy', $user) }}" class="p-6 space-y-4">
                                            @csrf
                                            @method('DELETE')
                                            <div>
                                                <p class="text-lg font-semibold text-ink">{{ __('Delete') }} {{ $user->name }}?</p>
                                                <p class="mt-2 text-sm text-muted">{{ __('This action cannot be undone.') }}</p>
                                            </div>
                                            <div class="flex justify-end gap-3">
                                                <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                                                <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                                            </div>
                                        </form>
                                    </x-modal>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="py-6 text-center text-sm text-muted">{{ __('No users found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3 view-grid">
                @forelse ($users as $user)
                    <div class="rounded-2xl border border-border/70 bg-surface-2/80 p-5">
                        <div class="flex items-center gap-3">
                            <span class="h-12 w-12 overflow-hidden rounded-full border border-border bg-surface-2/80">
                                @if ($user->profile_photo_path)
                                    <img src="{{ asset('storage/' . $user->profile_photo_path) }}" alt="{{ $user->name }}" class="h-full w-full object-cover">
                                @else
                                    <img src="{{ asset('images/placeholder-user.svg') }}" alt="Placeholder avatar" class="h-full w-full object-cover">
                                @endif
                            </span>
                            <div>
                                <p class="font-semibold text-ink">{{ $user->name }}</p>
                                <p class="text-xs text-muted">{{ $user->email }}</p>
                            </div>
                        </div>
                        <div class="mt-4 flex flex-wrap gap-2">
                            @forelse ($user->roles as $role)
                                <span class="badge">{{ $role->name }}</span>
                            @empty
                                <span class="badge">{{ __('Unassigned') }}</span>
                            @endforelse
                        </div>
                        <div class="mt-4 text-xs text-muted">
                            {{ $user->is_active ? __('Active') : __('Inactive') }}
                        </div>
                        <div class="mt-4 flex items-center gap-2">
                            <a href="{{ route('admin.users.show', $user) }}" class="btn-secondary">{{ __('View') }}</a>
                            <a href="{{ route('admin.users.edit', $user) }}" class="btn-secondary">{{ __('Edit') }}</a>
                        </div>
                    </div>
                @empty
                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">{{ __('No users found.') }}</div>
                @endforelse
            </div>

            <x-modal name="import-users" :show="false" focusable>
                <form method="POST" action="{{ route('admin.users.import') }}" enctype="multipart/form-data" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Import Users') }}</p>
                        <p class="mt-2 text-sm text-muted">{{ __('Upload a CSV file that matches the provided template.') }}</p>
                    </div>
                    <div>
                        <x-input-label for="users_file" :value="__('CSV File')" />
                        <input id="users_file" name="file" type="file" accept=".csv" class="mt-2 text-sm text-muted" required>
                        <x-input-error :messages="$errors->get('file')" class="mt-2" />
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-primary-button type="submit">{{ __('Upload') }}</x-primary-button>
                    </div>
                </form>
            </x-modal>

            <x-modal name="confirm-user-bulk-delete" :show="false" focusable>
                <form method="POST" action="{{ route('admin.users.bulk-destroy') }}" class="p-6 space-y-4">
                    @csrf
                    @method('DELETE')
                    <div data-bulk-target></div>
                    <div>
                        <p class="text-lg font-semibold text-ink">{{ __('Delete selected users?') }}</p>
                        <p class="mt-2 text-sm text-muted">
                            You are about to remove <span class="font-semibold text-ink" data-bulk-selected>0</span> user(s).
                        </p>
                    </div>
                    <div class="flex justify-end gap-3">
                        <x-secondary-button type="button" x-on:click="$dispatch('close')">{{ __('Cancel') }}</x-secondary-button>
                        <x-danger-button type="submit">{{ __('Delete') }}</x-danger-button>
                    </div>
                </form>
            </x-modal>

            <div class="mt-6">
                {{ $users->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
