﻿@php
    $isEdit = isset($user) && $user;
    $selectedRoles = old('roles', $isEdit ? $user->roles->pluck('name')->all() : []);
    $selectedPlan = old('plan_id', $isEdit ? $user->plan_id : null);
    $selectedCountry = old('country_id', $isEdit ? $user->country_id : null);
    $selectedState = old('state_id', $isEdit ? $user->state_id : null);
    $selectedCity = old('city_id', $isEdit ? $user->city_id : null);
@endphp

<div class="grid gap-6 lg:grid-cols-2" data-location-scope>
    <div class="panel p-6">
        <p class="panel-heading">{{ __('Personal Details') }}</p>
        <div class="mt-4 grid gap-4">
            <div class="flex items-center gap-4">
                <div class="h-16 w-16 overflow-hidden rounded-2xl border border-border bg-surface-2/80">
                    @if ($isEdit && $user->profile_photo_path)
                        <img src="{{ asset('storage/' . $user->profile_photo_path) }}" alt="{{ $user->name }}" class="h-full w-full object-cover">
                    @else
                        <img src="{{ asset('images/placeholder-user.svg') }}" alt="Placeholder avatar" class="h-full w-full object-cover">
                    @endif
                </div>
                <div>
                    <x-input-label for="profile_photo" :value="__('Profile Photo')" />
                    <input id="profile_photo" name="profile_photo" type="file" accept=".jpg,.jpeg,.png,.webp" class="mt-2 text-sm text-muted">
                    <p class="mt-2 text-xs text-muted">{{ __('JPG, JPEG, PNG, or WEBP. Max 10MB.') }}</p>
                    <x-input-error :messages="$errors->get('profile_photo')" class="mt-2" />
                </div>
            </div>

            <div>
                <x-input-label for="name" :value="__('Full Name')" />
                <x-text-input id="name" name="name" type="text" pattern="[A-Za-z][A-Za-z\s.'-]{0,39}" maxlength="40" class="mt-1" :value="old('name', $isEdit ? $user->name : '')" required />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="email" :value="__('Email')" />
                <x-text-input id="email" name="email" type="email" maxlength="30" class="mt-1" :value="old('email', $isEdit ? $user->email : '')" required />
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="phone" :value="__('Mobile Number')" />
                <x-text-input id="phone" name="phone" type="text" inputmode="tel" pattern="\+?[0-9]{1,15}" maxlength="15" data-phone-input class="mt-1" :value="old('phone', $isEdit ? $user->phone : '')" placeholder="{{ __('+91XXXXXXXXXX') }}" />
                <x-input-error :messages="$errors->get('phone')" class="mt-2" />
            </div>

            <div>
                <x-input-label :value="__('Gender')" />
                <div class="mt-2 flex flex-wrap gap-4 text-sm text-muted">
                    @foreach (['male' => 'Male', 'female' => 'Female', 'other' => 'Other'] as $value => $label)
                        <label class="inline-flex items-center gap-2">
                            <input type="radio" name="gender" value="{{ $value }}" class="h-4 w-4 border-border text-brand focus:ring-brand/40" @checked(old('gender', $isEdit ? $user->gender : '') === $value)>
                            {{ $label }}
                        </label>
                    @endforeach
                </div>
                <x-input-error :messages="$errors->get('gender')" class="mt-2" />
            </div>
        </div>
    </div>

    <div class="panel p-6">
        <p class="panel-heading">{{ __('Access & Status') }}</p>
        <div class="mt-4 grid gap-4">
            <div>
                <x-input-label :value="__('User Roles')" />
                <div class="mt-2 grid gap-2 text-sm text-muted sm:grid-cols-2">
                    @foreach ($roles as $role)
                        <label class="inline-flex items-center gap-2">
                            <input type="checkbox" name="roles[]" value="{{ $role->name }}" class="h-4 w-4 rounded border-border text-brand focus:ring-brand/40" @checked(in_array($role->name, $selectedRoles, true))>
                            {{ $role->name }}
                        </label>
                    @endforeach
                </div>
                @php
                    $roleErrors = array_merge($errors->get('roles'), $errors->get('roles.*'));
                @endphp
                <x-input-error :messages="$roleErrors" class="mt-2" />
            </div>

            <div>
                <x-input-label for="plan_id" :value="__('Plan')" />
                <select id="plan_id" name="plan_id" class="input-field mt-1">
                    <option value="">{{ __('No plan assigned') }}</option>
                    @foreach ($plans as $plan)
                        <option value="{{ $plan->id }}" @selected((string) $selectedPlan === (string) $plan->id)>
                            {{ $plan->name }}
                        </option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('plan_id')" class="mt-2" />
            </div>

            <div>
                <x-input-label :value="__('Password')" />
                <div class="relative mt-1">
                    <x-text-input id="{{ $isEdit ? 'password_edit' : 'password' }}" name="password" type="password" class="pr-12" autocomplete="new-password" placeholder="{{ $isEdit ? 'Enter new password' : '' }}" @if (! $isEdit) required @endif />
                    <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="{{ $isEdit ? 'password_edit' : 'password' }}" aria-label="Toggle password visibility">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                            <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                            <circle cx="12" cy="12" r="3"></circle>
                        </svg>
                        <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                            <path d="M3 5l16 16"></path>
                            <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                            <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                            <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                        </svg>
                    </button>
                </div>
                @if ($isEdit)
                    <p class="mt-2 text-xs text-muted">{{ __('Leave blank to keep the current password.') }}</p>
                @endif
                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <div>
                <x-input-label :value="__('Confirm Password')" />
                <div class="relative mt-1">
                    <x-text-input id="{{ $isEdit ? 'password_confirmation_edit' : 'password_confirmation' }}" name="password_confirmation" type="password" class="pr-12" autocomplete="new-password" placeholder="{{ $isEdit ? 'Confirm new password' : '' }}" @if (! $isEdit) required @endif />
                    <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="{{ $isEdit ? 'password_confirmation_edit' : 'password_confirmation' }}" aria-label="Toggle password visibility">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                            <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                            <circle cx="12" cy="12" r="3"></circle>
                        </svg>
                        <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                            <path d="M3 5l16 16"></path>
                            <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                            <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                            <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                        </svg>
                    </button>
                </div>
                <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
            </div>

            <div class="flex flex-wrap items-center gap-6">
                <div>
                    <x-input-label :value="__('Status')" />
                    <input type="hidden" name="is_active" value="0">
                    <label class="mt-2 inline-flex items-center gap-3 text-sm text-muted">
                        <input type="checkbox" name="is_active" value="1" class="peer sr-only" @checked((bool) old('is_active', $isEdit ? $user->is_active : true))>
                        <span class="relative inline-flex h-6 w-11 items-center rounded-full bg-border transition peer-checked:bg-brand [--switch-x:0.125rem] peer-checked:[--switch-x:1.25rem]">
                            <span class="inline-block h-5 w-5 translate-x-[var(--switch-x)] rounded-full bg-white shadow transition"></span>
                        </span>
                        <span>{{ old('is_active', $isEdit ? $user->is_active : true) ? __('Active') : __('Inactive') }}</span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="panel p-6 lg:col-span-2">
        <p class="panel-heading">{{ __('Address') }}</p>
        <div class="mt-4 grid gap-4 lg:grid-cols-2">
            <div class="lg:col-span-2">
                <x-input-label for="address_line" :value="__('Address')" />
                <x-text-input id="address_line" name="address_line" type="text" class="mt-1" :value="old('address_line', $isEdit ? $user->address_line : '')" />
                <x-input-error :messages="$errors->get('address_line')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="country_id" :value="__('Country')" />
                <select id="country_id" name="country_id" class="input-field mt-1" data-country-select>
                    <option value="">{{ __('Select country') }}</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}" @selected((string) $selectedCountry === (string) $country->id)>{{ $country->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('country_id')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="state_id" :value="__('State')" />
                <select id="state_id" name="state_id" class="input-field mt-1" data-state-select>
                    <option value="">{{ __('Select state') }}</option>
                    @foreach ($states as $state)
                        <option value="{{ $state->id }}" data-country-id="{{ $state->country_id }}" @selected((string) $selectedState === (string) $state->id)>{{ $state->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('state_id')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="city_id" :value="__('City')" />
                <select id="city_id" name="city_id" class="input-field mt-1" data-city-select>
                    <option value="">{{ __('Select city') }}</option>
                    @foreach ($cities as $city)
                        <option value="{{ $city->id }}" data-state-id="{{ $city->state_id }}" @selected((string) $selectedCity === (string) $city->id)>{{ $city->name }}</option>
                    @endforeach
                </select>
                <x-input-error :messages="$errors->get('city_id')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="postal_code" :value="__('Pin/Zip Code')" />
                <x-text-input id="postal_code" name="postal_code" type="text" class="mt-1" :value="old('postal_code', $isEdit ? $user->postal_code : '')" />
                <x-input-error :messages="$errors->get('postal_code')" class="mt-2" />
            </div>
        </div>
    </div>
</div>

