<x-admin-layout :title="$user->name" :subtitle="__('User profile overview and access details.')">
    <div class="space-y-6">
        <div class="flex flex-wrap items-center justify-between gap-4">
            <a href="{{ route('admin.users.index') }}" class="btn-secondary">{{ __('Back to Users') }}</a>
            <div class="flex flex-wrap items-center gap-3">
                <a href="{{ route('admin.users.edit', $user) }}" class="btn-secondary">{{ __('Edit User') }}</a>
                <form method="POST" action="{{ route('admin.users.destroy', $user) }}" onsubmit="return confirm('{{ __('Delete this user?') }}');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn-danger">{{ __('Delete') }}</button>
                </form>
            </div>
        </div>

        <div class="grid gap-6 lg:grid-cols-3">
            <div class="panel p-6 lg:col-span-1">
                <p class="panel-heading">{{ __('Profile') }}</p>
                <div class="mt-4 flex flex-col items-center text-center">
                    <div class="h-24 w-24 overflow-hidden rounded-3xl border border-border bg-surface-2/80">
                        @if ($user->profile_photo_path)
                            <img src="{{ asset('storage/' . $user->profile_photo_path) }}" alt="{{ $user->name }}" class="h-full w-full object-cover">
                        @else
                            <img src="{{ asset('images/placeholder-user.svg') }}" alt="Placeholder avatar" class="h-full w-full object-cover">
                        @endif
                    </div>
                    <h3 class="mt-4 text-lg font-semibold text-ink">{{ $user->name }}</h3>
                    <p class="text-sm text-muted">{{ $user->email }}</p>
                    <div class="mt-3 flex flex-wrap justify-center gap-2">
                        @forelse ($user->roles as $role)
                            <span class="badge">{{ $role->name }}</span>
                        @empty
                            <span class="badge">{{ __('Unassigned') }}</span>
                        @endforelse
                    </div>
                </div>
            </div>

            <div class="panel p-6 lg:col-span-2">
                <p class="panel-heading">{{ __('Account Details') }}</p>
                <div class="mt-4 grid gap-4 sm:grid-cols-2">
                    <div>
                        <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Mobile') }}</p>
                        <p class="mt-2 text-sm text-ink">{{ $user->phone ?: __('Not provided') }}</p>
                    </div>
                    <div>
                        <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Gender') }}</p>
                        <p class="mt-2 text-sm text-ink">{{ $user->gender ? ucfirst($user->gender) : __('Not set') }}</p>
                    </div>
                    <div>
                        <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Status') }}</p>
                        <p class="mt-2 text-sm text-ink">{{ $user->is_active ? __('Active') : __('Inactive') }}</p>
                    </div>
                    <div>
                        <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Plan') }}</p>
                        <p class="mt-2 text-sm text-ink">{{ $user->plan?->name ?? __('Not set') }}</p>
                    </div>
                    <div class="sm:col-span-2">
                        <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Address') }}</p>
                        <p class="mt-2 text-sm text-ink">
                            {{ $user->address_line ?: __('Not provided') }}
                        </p>
                        <p class="mt-1 text-xs text-muted">
                            {{ collect([$user->city?->name, $user->state?->name, $user->country?->name])->filter()->join(', ') ?: __('No location set') }}
                            @if ($user->postal_code)
                                · {{ $user->postal_code }}
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
