<x-guest-layout>
    <div class="space-y-4">
        <div>
            <span class="badge">{{ __('Secure step') }}</span>
            <h2 class="mt-3 text-2xl font-semibold text-ink">{{ __('Confirm your password') }}</h2>
            <p class="mt-2 text-sm text-muted">
                {{ __('This keeps sensitive admin actions protected.') }}
            </p>
        </div>

        <form method="POST" action="{{ route('password.confirm') }}" class="space-y-4">
            @csrf

            <div>
                <x-input-label for="password" :value="__('Password')" />
                <div class="relative mt-1">
                    <x-text-input id="password" class="pr-12" type="password" name="password" required autocomplete="current-password" />
                    <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="password" aria-label="Toggle password visibility">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                            <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                            <circle cx="12" cy="12" r="3"></circle>
                        </svg>
                        <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                            <path d="M3 5l16 16"></path>
                            <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                            <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                            <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                        </svg>
                    </button>
                </div>
                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <div class="flex justify-end">
                <x-primary-button>
                    {{ __('Confirm') }}
                </x-primary-button>
            </div>
        </form>
    </div>
</x-guest-layout>
