@extends('layouts.frontend')

@section('title', __('Reset Password') . ' - ' . config('app.name', 'SnapNest'))

@section('content')
<div class="min-h-screen flex items-center justify-center bg-muted/30 p-4">
    <div class="w-full max-w-md bg-card border border-border shadow-xl rounded-xl overflow-hidden">
        <div class="p-6 text-center space-y-2">
           <a href="{{ url('/') }}" class="inline-flex items-center justify-center gap-2 font-bold text-xl mb-4 text-primary">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>
              <span>{{ config('app.name', 'SnapNest') }}</span>
           </a>
          <h2 class="text-2xl font-bold">{{ __('Reset Password') }}</h2>
          <p class="text-sm text-muted-foreground">
            {{ __('Enter your email and we will send you a reset link') }}
          </p>
        </div>
        
        <div class="p-6 pt-0 space-y-6">
          <form method="POST" action="{{ route('password.email') }}" class="space-y-4">
            @csrf
            
             @if (session('status'))
                <div class="mb-4 font-medium text-sm text-green-600 dark:text-green-400">
                    {{ session('status') }}
                </div>
            @endif

            <div class="space-y-2">
              <label for="email" class="text-sm font-medium leading-none">{{ __('Email') }}</label>
              <input 
                id="email" 
                type="email" 
                name="email"
                placeholder="{{ __('m@example.com') }}" 
                class="flex h-10 w-full rounded-md border border-input bg-transparent px-3 py-2 text-sm ring-offset-background file:border-0 file:bg-transparent file:text-sm file:font-medium placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:cursor-not-allowed disabled:opacity-50"
                required 
                value="{{ old('email') }}"
               />
                @error('email')
                    <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                @enderror
            </div>
            
            <button type="submit" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary text-primary-foreground hover:bg-primary/90 h-10 px-4 py-2 w-full">
                {{ __('Send Reset Link') }}
            </button>
          </form>
        </div>
        
        <div class="flex items-center p-6 pt-0 justify-center">
             <a href="{{ route('login') }}" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 text-primary underline-offset-4 hover:underline h-10 px-4 py-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 h-4 w-4"><path d="m12 19-7-7 7-7"/><path d="M19 12H5"/></svg> {{ __('Back to Login') }}
             </a>
        </div>
    </div>
</div>
@endsection
