@extends('layouts.frontend')

@section('title', __('Sign Up') . ' - ' . config('app.name', 'SnapNest'))
@section('hide_header', true)
@section('hide_footer', true)

@section('content')
<div class="h-screen bg-background text-foreground selection:bg-primary/30 flex overflow-hidden relative transition-colors duration-500">
    
    <!-- Left Side: Brand Story -->
    <div class="hidden lg:flex lg:w-1/2 relative flex-col justify-between p-16 overflow-hidden bg-muted/30 dark:bg-zinc-900/50">
        <div class="absolute inset-0 bg-[radial-gradient(circle_at_70%_50%,rgba(var(--primary),0.1),transparent)] pointer-events-none"></div>
        <div class="absolute top-0 right-0 w-px h-full bg-gradient-to-b from-transparent via-border to-transparent"></div>
        
        <div class="relative z-10 space-y-12">
            <div
                x-data="{ shown: false }"
                x-init="setTimeout(() => shown = true, 0)"
                class="space-y-6 transition-all duration-700 transform"
                :class="shown ? 'opacity-100 scale-100' : 'opacity-0 scale-95'">
                <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary/10 border border-primary/20 text-primary text-[9px] font-bold uppercase tracking-widest">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L12 3Z"/></svg> {{ __('Early Access Open') }}
                </div>
                <h2 class="text-5xl font-bold leading-tight tracking-tight text-balance text-foreground">
                    {{ __('JOIN THE') }} <br />
                    <span class="bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent">{{ __('ELITE.') }}</span>
                </h2>
                <p class="text-muted-foreground text-lg max-w-sm font-medium leading-relaxed">
                    {{ __('Designed for photographers who demand perfection in every pixel and every delivery.') }}
                </p>
            </div>

            <div class="space-y-4">
                @foreach([
                    __("Smart Event Photo Management"),
                    __("Face Recognition"),
                    __("Secure Client Photo Delivery"),
                    __("Custom Watermark Protection")
                ] as $text)
                    <div class="flex items-center gap-3 text-muted-foreground group cursor-default">
                        <div class="h-4 w-4 rounded-full bg-primary/10 border border-primary/20 flex items-center justify-center group-hover:bg-primary/20 transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3 text-primary"><circle cx="12" cy="12" r="10"/><path d="m9 12 2 2 4-4"/></svg>
                        </div>
                        <span class="text-[13px] font-bold tracking-tight group-hover:text-foreground transition-colors">{{ $text }}</span>
                    </div>
                @endforeach
            </div>
        </div>

    </div>

    <!-- Right Side: Signup Form -->
    <div class="flex-1 flex flex-col justify-center items-center p-8 md:p-16 bg-background relative overflow-hidden border-l border-border/50">
        <div class="w-full max-w-sm space-y-7 relative z-10 text-foreground">
            
            <div class="space-y-2">
                <h1 class="text-3xl font-bold tracking-tight">
                    {{ __('Create Your') }} <br />
                    <span class="text-primary italic">{{ __('Identity.') }}</span>
                </h1>
                <p class="text-muted-foreground text-xs font-medium">{{ __('Join the professional standard for photo sharing.') }}</p>
            </div>

            <form method="POST" action="{{ route('register') }}" class="space-y-5">
                @csrf
                <div class="space-y-4">
                    <div class="space-y-2 group">
                        <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors flex items-center gap-2">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/></svg> {{ __('Full Name') }}
                        </label>
                        <input 
                            name="name"
                            placeholder="{{ __('Alex Studio') }}" 
                            class="flex h-12 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                            required
                            value="{{ old('name') }}"
                        />
                        @error('name')
                            <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="space-y-2 group">
                        <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors flex items-center gap-2">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><rect width="20" height="16" x="2" y="4" rx="2"/><path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"/></svg> {{ __('Working Email') }}
                        </label>
                        <input 
                            type="email" 
                            name="email"
                            placeholder="{{ __('alex@studio.com') }}" 
                            class="flex h-12 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                            required
                            value="{{ old('email') }}"
                        />
                         @error('email')
                            <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="space-y-2 group">
                        <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors flex items-center gap-2">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/></svg> {{ __('Password') }}
                        </label>
                        <input
                            type="password"
                            name="password"
                            class="flex h-12 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all text-sm text-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                            required
                        />
                         @error('password')
                            <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="space-y-2 group">
                        <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors flex items-center gap-2">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/></svg> {{ __('Confirm Password') }}
                        </label>
                        <input 
                            type="password" 
                            name="password_confirmation"
                            class="flex h-12 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all text-sm text-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                            required
                        />
                         @error('password_confirmation')
                            <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="flex items-start gap-3 p-4 rounded-xl bg-muted/30 border border-border/50">
                    <input type="checkbox" name="terms" class="mt-1 h-3.5 w-3.5 rounded border-border bg-background text-primary focus:ring-primary" required />
                    <p class="text-[10px] leading-relaxed text-muted-foreground">
                        {{ __('I agree to the') }} <a href="{{ route('legal.terms') }}" class="text-primary hover:underline font-bold">{{ __('Membership Agreement') }}</a> {{ __('and data privacy standards.') }}
                    </p>
                </div>

                <button type="submit" class="w-full h-12 rounded-xl bg-primary hover:bg-primary/90 text-base font-bold shadow-lg shadow-primary/20 transition-all active:scale-95 group text-primary-foreground">
                    {{ __('Begin Your Journey') }}
                </button>
            </form>

            <div class="pt-2">
                <p class="text-center text-[11px] font-medium text-muted-foreground">
                    {{ __('Already a member?') }}
                    <a href="{{ route('login') }}" class="text-primary font-bold hover:underline ml-1">
                        {{ __('Sign In') }}
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>
@endsection
