<x-guest-layout>
    <div class="space-y-6">
        <div>
            <span class="badge">{{ __('Two-factor') }}</span>
            <h2 class="mt-3 text-3xl font-semibold text-ink">{{ __('Verify your sign in') }}</h2>
            <p class="mt-2 text-sm text-muted">
                {{ __('Enter the 6-digit code from your authenticator app for') }} {{ $email }}.
            </p>
        </div>

        <form method="POST" action="{{ route('two-factor.challenge.store') }}" class="space-y-4">
            @csrf

            <div>
                <x-input-label for="code" :value="__('Authentication Code')" />
                <x-text-input id="code" name="code" type="text" class="mt-1" inputmode="numeric" autocomplete="one-time-code" required autofocus placeholder="{{ __('123456') }}" />
                <x-input-error :messages="$errors->get('code')" class="mt-2" />
            </div>

            <div class="flex items-center justify-between pt-2">
                <a class="text-sm text-muted transition hover:text-ink" href="{{ route('login') }}">
                    {{ __('Back to login') }}
                </a>
                <x-primary-button>
                    {{ __('Verify') }}
                </x-primary-button>
            </div>
        </form>
    </div>
</x-guest-layout>
