<x-guest-layout>
    <div class="space-y-6">
        <div>
            <span class="badge">{{ __('Two-factor setup') }}</span>
            <h2 class="mt-3 text-3xl font-semibold text-ink">{{ __('Secure your admin access') }}</h2>
            <p class="mt-2 text-sm text-muted">
                {{ __('Scan the QR code with your authenticator app (Google Authenticator, Authy, etc.) for') }} {{ $email }}, {{ __('then enter the 6-digit code below.') }}
            </p>
        </div>

        <div class="flex flex-col items-center gap-5 sm:flex-row sm:items-start">
            <div class="shrink-0 rounded-2xl border border-border bg-white p-3 shadow-soft">
                <img src="https://api.qrserver.com/v1/create-qr-code/?size=192x192&data={{ urlencode($otpAuthUrl) }}" alt="2FA QR Code" width="192" height="192" class="rounded-lg" />
            </div>
            <div class="flex-1 min-w-0 space-y-3" x-data="{ showManual: false }">
                <p class="text-sm font-semibold text-ink">{{ __('Scan QR Code') }}</p>
                <p class="text-xs text-muted">{{ __('Open your authenticator app and scan the code. The issuer will show as') }} <strong>{{ $issuer }}</strong>.</p>
                <button type="button" class="text-xs font-medium text-brand hover:underline" @click="showManual = !showManual" x-text="showManual ? 'Hide manual key' : 'Can\'t scan? Enter key manually'"></button>
                <div x-show="showManual" x-cloak class="rounded-xl border border-border bg-surface-2 p-3">
                    <p class="text-[10px] font-bold uppercase tracking-widest text-muted">{{ __('Secret Key') }}</p>
                    <p class="mt-1 select-all break-all font-mono text-sm text-ink">{{ $secret }}</p>
                </div>
            </div>
        </div>

        <form method="POST" action="{{ route('two-factor.setup.store') }}" class="space-y-4">
            @csrf

            <div>
                <x-input-label for="code" :value="__('Verification Code')" />
                <x-text-input id="code" name="code" type="text" class="mt-1" inputmode="numeric" autocomplete="one-time-code" maxlength="6" required autofocus placeholder="{{ __('000000') }}" />
                <x-input-error :messages="$errors->get('code')" class="mt-2" />
                @if (session('error'))
                    <p class="mt-2 text-sm text-danger">{{ session('error') }}</p>
                @endif
            </div>

            <div class="flex items-center justify-between pt-2">
                <a class="text-sm text-muted transition hover:text-ink" href="{{ route('login') }}">
                    {{ __('Back to login') }}
                </a>
                <x-primary-button>
                    {{ __('Enable 2FA') }}
                </x-primary-button>
            </div>
        </form>
    </div>
</x-guest-layout>
