<x-guest-layout>
    <div class="space-y-4">
        <div>
            <span class="badge">{{ __('Verify email') }}</span>
            <h2 class="mt-3 text-2xl font-semibold text-ink">{{ __('Confirm your email address') }}</h2>
            <p class="mt-2 text-sm text-muted">
                {{ __('We sent a secure verification link. Open your inbox to finish onboarding.') }}
            </p>
        </div>

        @if (session('status') == 'verification-link-sent')
            <div class="rounded-xl border border-success/40 bg-success/10 px-4 py-3 text-sm text-success">
                {{ __('A new verification link has been sent to your email address.') }}
            </div>
        @endif

        <div class="flex flex-wrap items-center gap-3">
            <form method="POST" action="{{ route('verification.send') }}">
                @csrf
                <x-primary-button>
                    {{ __('Resend Verification Email') }}
                </x-primary-button>
            </form>

            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit" class="btn-secondary">
                    {{ __('Log Out') }}
                </button>
            </form>
        </div>
    </div>
</x-guest-layout>
