<x-guest-layout>
    <div class="space-y-6">
        <div>
            <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Browser Not Supported') }}</p>
            <h2 class="mt-3 text-3xl font-semibold text-ink">{{ __('Please switch browsers.') }}</h2>
            <p class="mt-3 text-sm text-muted">{{ $message ?? __('This browser is blocked by system policy.') }}</p>
        </div>
        <div class="rounded-xl border border-dashed border-border/70 bg-surface-2/60 p-4 text-xs text-muted">
            <p>{{ __('Recommended: Chrome, Edge, or Safari for the best experience.') }}</p>
        </div>
        @php
            $supportEmail = trim((string) ($generalSettings['support_email'] ?? ''));
        @endphp
        <div class="flex flex-wrap gap-3">
            <a href="{{ route('login') }}" class="btn-primary">{{ __('Return to login') }}</a>
            @if ($supportEmail !== '')
                <a href="mailto:{{ $supportEmail }}" class="btn-secondary">{{ __('Contact support') }}</a>
            @endif
        </div>
    </div>
</x-guest-layout>
