@extends('layouts.frontend')

@section('title', __('Payment Cancelled'))

@section('content')
<main class="flex-1 pt-32 pb-20 overflow-hidden relative">
    <!-- Ambient Background -->
    <div class="absolute top-0 right-0 w-[50%] h-[50%] bg-primary/5 blur-[120px] rounded-full -z-10"></div>
    <div class="absolute bottom-0 left-0 w-[50%] h-[50%] bg-accent/5 blur-[120px] rounded-full -z-10"></div>

    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto">
            <div
                x-data="{ shown: false }"
                x-init="setTimeout(() => shown = true, 0)"
                class="p-10 md:p-14 rounded-[3rem] bg-card border border-border shadow-2xl text-center transition-all duration-700 transform"
                :class="shown ? 'opacity-100 scale-100' : 'opacity-0 scale-95'">

                <!-- Cancel Icon -->
                <div class="mx-auto mb-8 h-20 w-20 rounded-full bg-amber-500/10 flex items-center justify-center">
                    <div class="h-14 w-14 rounded-full bg-amber-500/20 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round" class="text-amber-500"><circle cx="12" cy="12" r="10"/><line x1="12" x2="12" y1="8" y2="12"/><line x1="12" x2="12.01" y1="16" y2="16"/></svg>
                    </div>
                </div>

                <h1 class="text-3xl md:text-4xl font-bold tracking-tight mb-3">{{ __('Payment Cancelled') }}</h1>
                <p class="text-lg text-muted-foreground mb-4">{{ __('Your payment was not completed. No charges have been made.') }}</p>

                @if(session('error'))
                    <div class="bg-red-500/10 border border-red-500/20 rounded-2xl p-4 mb-8">
                        <p class="text-sm font-medium text-red-600 dark:text-red-400">{{ session('error') }}</p>
                    </div>
                @endif

                <p class="text-sm text-muted-foreground mb-10">
                    {{ __('If you experienced any issues, please try again or contact our support team for help.') }}
                </p>

                <!-- Actions -->
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="{{ url('/#pricing') }}" class="flex-1 h-14 rounded-2xl bg-primary hover:bg-primary/90 text-primary-foreground font-bold flex items-center justify-center transition-all shadow-lg shadow-primary/20 group">
                        {{ __('Try Again') }}
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 group-hover:translate-x-1 transition-transform"><path d="M21 12a9 9 0 0 0-9-9 9.75 9.75 0 0 0-6.74 2.74L3 8"/><path d="M3 3v5h5"/><path d="M3 12a9 9 0 0 0 9 9 9.75 9.75 0 0 0 6.74-2.74L21 16"/><path d="M16 16h5v5"/></svg>
                    </a>
                    <a href="{{ route('contact') }}" class="flex-1 h-14 rounded-2xl bg-muted/50 hover:bg-muted text-foreground font-bold flex items-center justify-center transition-all">
                        {{ __('Contact Support') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
