@extends('layouts.frontend')

@section('title', __('Processing Payment'))

@section('content')
<main class="flex-1 pt-32 pb-20 overflow-hidden relative">
    <!-- Ambient Background -->
    <div class="absolute top-0 right-0 w-[50%] h-[50%] bg-primary/5 blur-[120px] rounded-full -z-10"></div>
    <div class="absolute bottom-0 left-0 w-[50%] h-[50%] bg-accent/5 blur-[120px] rounded-full -z-10"></div>

    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto">
            <div class="p-10 md:p-14 rounded-[3rem] bg-card border border-border shadow-2xl text-center">
                <h2 class="text-2xl font-bold mb-4">{{ __('Complete Your Payment') }}</h2>
                <p class="text-muted-foreground mb-8">{{ __('You are paying for the') }} <strong>{{ $plan->name }}</strong> {{ __('plan. Please complete the payment below.') }}</p>

                <div class="text-left">
                    {!! $html !!}
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
